import { reactive, readonly, computed } from "vue";
import axios from 'axios'
import 'js-loading-overlay'

const state = reactive({
    showSideBar:true,
    pageLoading: false,
    hotelSearch: {},
    hotel: {},
    flights: {},
    user: {
        logged: false,
        token: '',
        info: {}
    },
    notification: {
        open: false,
        icon: '',
        title: '',
        message: ''
    },
    screenType: 'desktop',
    page: {
        menu: []
    },
    b2c: {
        backend_url: '',
        frontend_url: '',
        access_token: ''
    },
    modules: {
        flights: "flights",
        hotels: "hotels",
        payments: "payments",
        content: "content",
        users: "users",
        admins: "admins",
        markups: "markups",
        coupons: "coupons",
        offers: "offers",
        notifications: "notifications",
        seo: "seo",
        locales: "locales",
        fixed_content: "fixed_content",
        tours: "tours",
        reports: "reports",
        settings: "settings"
    },
    permissions: []
})

const setAuthToken = (token) => {
    axios.defaults.headers.common['Authorization'] = 'Bearer ' + token
}

export default {
    isMobile: computed(() => state.screenType == 'mobile'),
    isTablet: computed(() => state.screenType == 'tablet'),
    isDesktop: computed(() => state.screenType == 'desktop'),
    isB2C: () => state.user.info.type && state.user.info.type == 'b2c',
    isB2B: () => state.user.info.type && state.user.info.type == 'b2b' || !state.user.info.type,
    isSuperAdmin : () => state.user.info.type == 'super_admin',
    isCompany : () => state.user.info.type == 'company',
    isEmployee : () => state.user.info.type == 'employee',
    isUserType: (type) =>  state.user.info.type == type,
    hasPermission: (permissions) => state.permissions.includes(permissions),
    // state,
    state: readonly(state),
    locale: reactive({}),
    setPageLoad(value){
        state.pageLoading = value
    },
    setUser(logged, token, info = null){
        state.user.logged = logged
        state.user.token = token
        if(info){
            state.user.info = info
            if(info.type == 'b2b' && info.settings){
                //set b2c base_url and token
                state.b2c = info.settings
                console.log(import.meta.env.DEV)
                if(import.meta.env.DEV){
                    state.b2c.backend_url = import.meta.env.VITE_B2C_BEASE_URL
                }
                console.log(state.b2c)
            }

            if(info.modules){
                state.modules = info.modules 
            }

            if(info.permissions){
                state.permissions = info.permissions
            }
        }
        
        let userInfo = {
            first_name: info.first_name,
            last_name: info.last_name,
            company: info.company,
        }
        window.localStorage.setItem('user', JSON.stringify({
            ...state.user,
            info: userInfo
        }))
        setAuthToken(token)
    },
    setAuthToken(token) {
        setAuthToken(token)
    },
    logout(){
        state.user = {
            logged: false,
            token: '',
            info: {}
        }

        window.localStorage.removeItem('user')
        delete axios.defaults.headers.common['Authorization']
        if(window.location.pathname != '/login')  window.location.href = '/login'
    },
    setNotification(obj){
        state.notification = {...state.notification, ...obj}
    },
    setScreenType(type){
        state.screenType = type
        // console.log(type)
    },
    setHotel(val){
        state.hotel = val
        window.localStorage.setItem('recentHotelSearch', JSON.stringify({
            name: val.HotelName,
            rate: val.HotelRating,
            address: val.HotelAddress,
            image: val.Files[0] || '',
            reviews: val.HotelTripadvisorRating,
            id: val.HotelId,
            tboId: val.HotelTboCode,
            wowCode: val.HotelWowCode
        }))
    },
    setHotelSearch(val){
        state.hotelSearch = val
    },
    setPage(page) {
        state.page = page
    },
    setFlights(data) {
        state.flights = data
    },
    showLoading () {
        // if(! state.isLoading) {
        //     // state.isLoading = true
        // }
        JsLoadingOverlay.show({
            'overlayBackgroundColor': '#666666',
            'overlayOpacity': 0.6,
            'spinnerIcon': 'ball-clip-rotate',
            'spinnerColor': 'orange',
            'spinnerSize': '2x',
            'overlayIDName': 'overlay',
            'spinnerIDName': 'spinner',
            'spinnerZIndex': 99999,
            'overlayZIndex': 99998
        })
    },
    hideLoading () {
        // state.isLoading = false
        JsLoadingOverlay.hide()
    },
    isLoading() {
        return state.isLoading
    },
    setSideBar(val){
        state.showSideBar=val
    }
}