<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Payments extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->string('module')->nullable();
            $table->string('supplier')->nullable();
            $table->integer('user_id');
            $table->integer('company_id');
            $table->integer('added_by');
            $table->integer('booking_id')->nullable();
            $table->decimal('amount', 18, 3)->default(0.000);
            $table->string('currency')->default('SAR');
            $table->string('type')->nullable();
            $table->tinyInteger('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
