<?php

namespace Modules\Users\Entities;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use App\Notifications\EmailVerificationNotification;
use App\Notifications\ResetPassword as ResetPasswordNotification;
use Carbon\Carbon;
use Spatie\Permission\Models\Role;

class User extends Authenticatable implements MustVerifyEmail
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;



    // public function sendEmailVerificationNotification()
    // {
    //     // We override the default notification and will use our own
    //     $this->notify(new EmailVerificationNotification());
    // }


    public function sendPasswordResetNotification($token)
    {
        // Your your own implementation.
        $this->notify(new ResetPasswordNotification($token));
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'parent_id',
        'title',
        'type',
        'first_name',
        'last_name',
        'email',
        'mobile',
        'image',
        'password',
        'is_email_verified',
        'credit_amount',
        'credit_allowed_amount',
        'company',
        'last_seen_at',
        'active'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    protected $guard_name = 'sanctum';

    public function getImageAttribute($value)
    {
        return $value ? env('APP_URL') . '/storage/user_images/' . $value: '' ;
    }
    public function setLastSeenAtAttribute($value)
    {
        $this->attributes['last_seen_at'] = Carbon::parse($value);
    }
}

