<?php

namespace Modules\Users\Entities;

use Spatie\Permission\Models\Role as Model;
use Spatie\Permission\PermissionRegistrar;

class Role extends Model
{
    protected $guard_name = 'sanctum';

    public static function create(array $attributes = [])
    {
        $attributes['guard_name'] = $attributes['guard_name'] ?? Guard::getDefaultName(static::class);

        $params = ['name' => $attributes['name'],'guard_name' => $attributes['guard_name'],'user_id'=>$attributes['user_id']];
        if (PermissionRegistrar::$teams) {
            if (array_key_exists(PermissionRegistrar::$teamsKey, $attributes)) {
                $params[PermissionRegistrar::$teamsKey] = $attributes[PermissionRegistrar::$teamsKey];
            } else {
                $attributes[PermissionRegistrar::$teamsKey] = app(PermissionRegistrar::class)->getPermissionsTeamId();
            }
        }
        if (static::findByParam($params)) {
            throw RoleAlreadyExists::create($attributes['name'], $attributes['guard_name'],$attributes['user_id']);
        }

        return static::query()->create($attributes);
    }
}
