<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Markup\Http\Controllers\MarkupController;
use Modules\Markup\Markup;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('/markup', function (Request $request) {
//     return $request->user();
// });

Route::group(
    [
        'prefix' => 'markup',
        'middleware' => ['has_permission', 'logger', 'language']
    ],
    function () {
        Route::get('/list/{type}', [MarkupController::class, 'list'])->name('markups_list');
        Route::get('/show/{type}/{id}', [MarkupController::class, 'show'])->name('markups_show');
        Route::post('/add/{type}', [MarkupController::class, 'store'])->name('markups_store');
        Route::put('/{id}/update', [MarkupController::class, 'update'])->name('markups_update');
        Route::delete('/{type}/{id}/delete', [MarkupController::class, 'delete'])->name('markups_delete');

        Route::get('/modules', [MarkupController::class, 'getModules'])->name('markups_modules');
        Route::get('/company/modules/{id}', [MarkupController::class, 'getCompanyModules'])->name('markups_modules');
        
        Route::get('/countries/{query}', [MarkupController::class, 'getCountries'])->name('markups_getCountries');
        Route::get('/cities/{countryCode}/{query}', [MarkupController::class, 'getCities'])->name('markups_getCities');
        Route::get('/hotels/{cityCode}/{query}', [MarkupController::class, 'getHotels'])->name('markups_getHotels');
        Route::get('/airlines/{query}', [MarkupController::class, 'getAirlines'])->name('markups_getAirlines');
        Route::get('/airports/{query}', [MarkupController::class, 'getAirports'])->name('markups_getAirports');
        Route::get('/destination', [MarkupController::class, 'getAirlineDestination'])->name('markups_getAirlineDestination');

        Route::get('/companies', [MarkupController::class, 'getCompanies'])->name('markups_getCompanies');
        Route::get('/employees/{id?}', [MarkupController::class, 'getEmployees'])->name('markups_getEmployees');
        Route::get('/modules/{id}', [MarkupController::class, 'getCompanyModules'])->name('markups_company_modules');


        /**
         * Testing
         */

        Route::post('test/single', function (Request $request) {
            $rules = $request->validate([
                'amount' => 'required|numeric',
                'module_id' => 'nullable',
                'supplier_id' => 'nullable',
                'hotel_id' => 'nullable',
                'city_id' => 'nullable'
            ]);

            // $rules = [
            //     'city_id' => 113117, // city
            //     'hotel_id' => 1444602, // hotel
            //     'module_id' => 9, // module
            //     'supplier_id' => 15, // supplier
            //     // 'supplier_id' => 18, // supplier
            //     'amount' => 100
            // ];
            $company_id = $request->get('parent');
            $user_id = $request->user()->id;

            $engine = new Markup();
            $engine->prepare([
                'modules' => [$rules['module_id']],
                'suppliers' => [$rules['supplier_id']],
                'hotels' => [$rules['hotel_id']],
                'cities' => [$rules['city_id']],
                'company_id' => $company_id,
                'employee_id' => $user_id
            ], $company_id);

            $markedPrice =  $engine->applyMarkups($rules['amount'], [
                'modules' => [$rules['module_id']],
                'supplier_id' => $rules['supplier_id'],
                'hotel_id' => $rules['hotel_id'],
                'city_id' => $rules['city_id']
            ]);

            return response()->json([
                'status' => true,
                'price' => $markedPrice
            ]);
        });

        Route::post('test/multiple', function (Request $request) {
            $rules = $request->validate([
                'hotels' => 'array|required',
                'hotels.*.amount' => 'required|numeric',
                'hotels.*.module_id' => 'nullable',
                'hotels.*.supplier_id' => 'nullable',
                'hotels.*.hotel_id' => 'nullable',
                'hotels.*.city_id' => 'nullable',
            ]);

            $company_id = $request->get('parent');
            $user_id = $request->user()->id;

            $modules = array_column($rules['hotels'], 'module_id');
            $suppliers = array_column($rules['hotels'], 'supplier_id');
            $hotels = array_column($rules['hotels'], 'hotel_id');
            $cities = array_column($rules['hotels'], 'city_id');
            // return $hotels;
            $engine = new Markup();
            $engine->prepare([
                'modules' => $modules,
                'suppliers' => $suppliers,
                'hotels' => $hotels,
                'cities' => $cities,
                'company_id' => $company_id,
                'employee_id' => $user_id
            ], $company_id);

            foreach ($rules['hotels'] as $key => $hotel) {

                $rules['hotels'][$key]['markedPrice'] =  $engine->applyMarkups($hotel['amount'], [
                    'modules' => [$hotel['module_id']],
                    'supplier_id' => $hotel['supplier_id'],
                    'hotel_id' => $hotel['hotel_id'],
                    'city_id' => $hotel['city_id'],
                ]);
            }

            return response()->json([
                'status' => true,
                'hotels' => $rules['hotels']
            ]);
        });
    }
);
