<?php

namespace Modules\Locales\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\Locales\Entities\City;

class CitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function cities_list()
    {
        $path = base_path() . '/Modules/Locales/Resources/city/cities.json';
        $cities = json_decode(file_get_contents($path), true);
        return $cities;
    }

    public function run()
    {
        $cities = $this->cities_list();
        foreach ((array)$cities as $city) {
            City::Create($city);
        }
    }
    // public function prepare_city_json(){
    //     $countries= Country::all();
    //     $path = base_path() . '/Modules/Locales/Resources/city/cities.json';
    //     $cities = json_decode(file_get_contents($path), true);
    //     return $cities;
    //     $city_list=[];
    //     foreach($countries as $country){
    //         foreach($cities as $city){
    //             if($city['country_code']==$country['id']){
    //                 $city['country_code']=$country['code'];
    //                 $city_list[]=$city;
    //             }
    //         }
    //     }
    //     file_put_contents($path,json_encode($city_list));
    // }
}
