<?php

namespace Modules\HotelMapping\Http\Controllers;

use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class BedsHotelsController extends Controller
{

    public function __construct()
    {

    }

    public function sendRequest($url)
    {

        set_time_limit(0);
        // $api = '654f3adebe111b5f0dab7dac224619c2';
        // $sec = 'c4458411f6';

        // $api='c356fd8a35a076de09e02a6f4a70dae8';
        // $sec='7ea00bc5c8';

        $api = 'uxq7g6ru4b662qhnqs3xgv9e';
        $sec = 'GZ4uwvpTRA';

        // $api = '38e74a774d4363083b1175264d88d28a';
        // $sec = '23dd9cecb3';

        $sig = hash("sha256", $api . $sec . time());
        $client = new Client();
        $headers = [
            'Api-key' => $api,
            'X-Signature' => $sig,
            'Accept' => 'application/json',
            'Accept-Encoding' => 'gzip',
        ];

        $request = new Request('GET', 'https://api.test.hotelbeds.com' . $url, $headers);
        $res = $client->sendAsync($request)->wait();
        return $res;
    }
// ======================================================Cities==============================

// store cities

    public function getCountryCities($country_code)
    {
        $url = "/hotel-content-api/1.0/locations/destinations?fields=all&countryCodes=" . $country_code . "&language=ENG&from=1&to=100&useSecondaryLanguage=false";
        return $this->sendRequest($url);
    }

    public function getAllCities()
    {
        $res = $this->getCountryCities('EG');
        $res = json_decode($res->getBody(), true);
        $cities = $res['destinations'];
        $all_cities = [];
        foreach ($cities as $item) {
            $city['code'] = $item['code'];
            $city['name_en'] = $item['name']['content'];
            $city['country_code'] = $item['countryCode'];
            $all_cities[] = $city;
            foreach ($item['zones'] as $zone) {
                $city['name_en'] = $zone['name'];
                $all_cities[] = $city;
            }
        }
        foreach ($all_cities as $city) {
            // try {
            $this->storeCities($city);
            // } catch (Exception $e) {

            // }
        }
    }

    public function storeCities($city)
    {
        DB::table('wow_beds_cities')->updateOrInsert(
            [
                'name_en' => $city['name_en'],
                'country_code' => $city['country_code'],
            ],
            [
                'name_en' => $city['name_en'] ?? '',
                'name_ar' => $city['name_ar'] ?? '',
                'country_code' => $city['country_code'] ?? '',
                'city_code' => $city['code'] ?? '',
            ]
        );
    }
//map cities

    public function mapCities()
    {
        set_time_limit(0);

        $beds_cities = DB::table('wow_beds_cities')->get();
        $wow_cities = DB::table('wow_cities')->where('country_id', 34)->get();
        // return $wow_cities;
        // $beds_cities = [
        //     [
        //         'id' => 1,
        //         'name_en' => 'cairo',
        //         'country_code' => 'eg',
        //         'city_code' => 'CAI',
        //     ],
        //     [
        //         'id' => 1,
        //         'name_en' => 'aledaria',
        //         'country_code' => 'eg',
        //         'city_code' => 'ALX',
        //     ],
        //     [
        //         'id' => 1,
        //         'name_en' => 'kafr',
        //         'country_code' => 'eg',
        //         'city_code' => 'KFR',
        //     ],
        //     [
        //         'id' => 1,
        //         'name_en' => 'Giza',
        //         'country_code' => 'eg',
        //         'city_code' => 'GZA',
        //     ],
        // ];
        // $wow_cities = [
        //     [
        //         'id' => 1,
        //         'name_en' => 'alcairo fdfd fkdkfk fkdfd',
        //         'country_code' => 'eg',
        //         'city_code' => 'CAI',
        //     ],
        //     [
        //         'id' => 1,
        //         'name_en' => 'aledaria',
        //         'country_code' => 'eg',
        //         'city_code' => 'ALX',
        //     ],
        //     [
        //         'id' => 1,
        //         'name_en' => 'kafr',
        //         'country_code' => 'eg',
        //         'city_code' => 'KFR',
        //     ],
        //     [
        //         'id' => 1,
        //         'name_en' => 'Giza nnnnn',
        //         'country_code' => 'eg',
        //         'city_code' => 'GZA',
        //     ],
        // ];
        $exists_cities = [];
        $not_exists_cities = [];
        foreach ($beds_cities as $beds_city) {
            $item = $this->checkExists($wow_cities, $beds_city->name_en, $beds_city->country_code);
            if ($item) {
                $exists_city['wow_city_id'] = $item->id;
                $exists_city['wow_name_en'] = $item->name_en;
                $exists_city['wow_name_ar'] = $item->name_ar;
                $exists_city['beds_name_en'] = $beds_city->name_en;
                $exists_city['beds_name_ar'] = $beds_city->name_ar;
                $exists_city['beds_country_code'] = $beds_city->country_code;
                $exists_city['beds_city_code'] = $beds_city->city_code;
                $exists_cities[] = $exists_city;
            } else {
                // $not_exists_city['wow_city_id'] = $item->id;
                // $not_exists_city['wow_name_en'] = $item->name_en;
                $not_exists_city['beds_name_en'] = $beds_city->name_en;
                // $not_exists_city['wow_name_ar'] = $item->name_ar;
                $not_exists_city['beds_name_ar'] = $beds_city->name_ar;
                $not_exists_city['beds_country_code'] = $beds_city->country_code;
                $not_exists_city['beds_city_code'] = $beds_city->city_code;
                $not_exists_cities[] = $not_exists_city;
            }
        }
        // try {
        return json_response([
            'Exists' => $this->storeReviewdCities($exists_cities),
            'Not_Exists' => $this->storeUnderReviewCities($not_exists_cities),
        ]);

        // } catch (Exception $e) {
        //     re $e;
        // }
    }

    public function storeReviewdCities($cities)
    {
        foreach ($cities as $city) {
            DB::table('wow_supplier_city_reviewed')->updateOrInsert(
                [
                    'wow_city_id' => $city['wow_city_id'],
                    'supplier_id' => 3,
                    'supplier_city_code' => $city['beds_city_code'],
                    'supplier_city_country_code' => $city['beds_country_code'],
                ],
                [
                    'wow_city_name_ar' => $city['wow_name_ar'] ?? '',
                    'wow_city_name_en' => $city['wow_name_en'] ?? '',
                    'supplier_city_name_en' => $city['beds_name_en'] ?? '',
                    'supplier_city_name_ar' => $city['beds_name_ar'] ?? '',
                ]
            );
        }
        return $cities;
    }

    public function storeUnderReviewCities($cities)
    {
        foreach ($cities as $city) {
            DB::table('wow_supplier_city_under_review')->updateOrInsert(
                [
                    'supplier_id' => 3,
                    'supplier_city_code' => $city['beds_city_code'],
                    'supplier_city_country_code' => $city['beds_country_code'],
                ],
                [
                    'supplier_city_name_en' => $city['beds_name_en'] ?? '',
                    'supplier_city_name_ar' => $city['beds_name_ar'] ?? '',
                ]
            );
        }
        return $cities;
    }

    public function checkExists($array, $name_en, $country_code)
    {
        foreach ($array as $item) {
            $item_country_code = $this->getCountryCode($item->country_id);
            if (strpos(strtoupper($item->name_en), strtoupper($name_en)) !== false && strtoupper($item_country_code) == strtoupper($country_code)) {
                return $item;
            }
        }
    }

    public function getCountryId($code)
    {
        $country = DB::table('wow_countries')->where('code', $code)->first();
        return $country->id;
    }
    public function getCountryCode($id)
    {
        $country = DB::table('wow_countries')->where('id', $id)->first();
        return $country->code;
    }

//store in city supplier table

    public function storeReviewedCities()
    {
        $reviwed_cities = DB::table('wow_supplier_city_reviewed')->get();
        foreach ($reviwed_cities as $city) {
            DB::table('wow_supplier_city')->updateOrInsert(
                [
                    'supplier_id' => $city->supplier_id,
                    'city_id' => $city->wow_city_id,
                ],
                [
                    'city_code' => $city->supplier_city_code,
                ]
            );
        }
    }

    //===========================================hotels=============================

//store hotels

    public function getCityHotels($city_code)
    {
        $url = "/hotel-content-api/1.0/hotels?fields=all&destinationCode=" . $city_code . "&language=ENG&from=1&to=100&useSecondaryLanguage=false";
        return $this->sendRequest($url);
    }
    public function getAllHotels()
    {
        $res = $this->getCityHotels('CAI');
        $res = json_decode($res->getBody(), true);
        $hotels = $res['hotels'];
        $all_hotels = [];
        foreach ($hotels as $item) {
            $hotel['code'] = $item['code'];
            $hotel['name_en'] = $item['name']['content'];
            $hotel['country_code'] = $item['countryCode'];
            $hotel['city_code'] = $item['destinationCode'];
            $all_hotels[] = $hotel;
        }
        foreach ($all_hotels as $hotel) {
            // try {
            $this->storeHotels($hotel);
            // } catch (Exception $e) {

            // }
        }
    }
    public function storeHotels($hotel)
    {
        DB::table('wow_beds_hotels')->updateOrInsert(
            [
                'name_en' => $hotel['name_en'],
                'city_code' => $hotel['city_code'],
                'country_code' => $hotel['country_code'],
            ],
            [
                'name_en' => $hotel['name_en'] ?? '',
                'country_code' => $hotel['country_code'] ?? '',
                'hotel_code' => $hotel['code'] ?? '',
            ]
        );
    }

//map hotels

    public function checkHotelExists($array, $name_en)
    {
        foreach ($array as $item) {
            if (strpos(strtoupper($item->name_en), strtoupper($name_en)) !== false) {
                return $item;
            }
        }
    }
    public function storeReviewdHotels($Hotels)
    {
        foreach ($Hotels as $hotel) {
            DB::table('wow_supplier_hotel_reviewed')->updateOrInsert(
                [
                    'wow_hotel_id' => $hotel['wow_hotel_id'],
                    'supplier_id' => 3,
                    'supplier_hotel_code' => $hotel['beds_hotel_code'],
                    'supplier_hotel_country_code' => $hotel['beds_country_code'],
                ],
                [
                    'wow_hotel_name_ar' => $hotel['wow_name_ar'] ?? '',
                    'wow_hotel_name_en' => $hotel['wow_name_en'] ?? '',
                    'supplier_hotel_name_en' => $hotel['beds_name_en'] ?? '',
                    'supplier_hotel_name_ar' => $hotel['beds_name_ar'] ?? '',
                ]
            );
        }
        return $Hotels;
    }

    public function storeUnderReviewHotels($Hotels)
    {
        foreach ($Hotels as $hotel) {
            DB::table('wow_supplier_hotel_under_review')->updateOrInsert(
                [
                    'supplier_id' => 3,
                    'supplier_hotel_code' => $hotel['beds_hotel_code'],
                    'supplier_hotel_country_code' => $hotel['beds_country_code'],
                ],
                [
                    'supplier_hotel_name_en' => $hotel['beds_name_en'] ?? '',
                    'supplier_hotel_name_ar' => $hotel['beds_name_ar'] ?? '',
                ]
            );
        }
        return $Hotels;
    }

    public function mapHotels()
    {
        set_time_limit(0);
        $beds_hotels = DB::table('wow_beds_hotels')->get();
        $wow_hotels = DB::table('wow_hotel_list')->where('city_id', 8940)->get();
        $exists_hotels = [];
        $not_exists_hotels = [];
        foreach ($beds_hotels as $beds_hotel) {
            $item = $this->checkHotelExists($wow_hotels, $beds_hotel->name_en);
            if ($item) {
                $exists_hotel['wow_hotel_id'] = $item->id;
                $exists_hotel['wow_name_en'] = $item->name_en;
                $exists_hotel['wow_name_ar'] = $item->name_ar;
                $exists_hotel['beds_name_en'] = $beds_hotel->name_en;
                // $exists_hotel['beds_name_ar'] = $beds_hotel->name_ar;
                $exists_hotel['beds_country_code'] = $beds_hotel->country_code;
                $exists_hotel['beds_hotel_code'] = $beds_hotel->hotel_code;
                $exists_hotel['beds_city_code'] = $beds_hotel->city_code;
                $exists_hotels[] = $exists_hotel;
            } else {
                $not_exists_hotel['beds_name_en'] = $beds_hotel->name_en;
                // $not_exists_hotel['beds_name_ar'] = $beds_hotel->name_ar;
                $not_exists_hotel['beds_country_code'] = $beds_hotel->country_code;
                $not_exists_hotel['beds_hotel_code'] = $beds_hotel->hotel_code;
                $exists_hotel['beds_city_code'] = $beds_hotel->city_code;
                $not_exists_hotels[] = $not_exists_hotel;
            }
        }
        // try {
        return json_response([
            'Exists' => $this->storeReviewdHotels($exists_hotels),
            'Not_Exists' => $this->storeUnderReviewHotels($not_exists_hotels),
        ]);

        // } catch (Exception $e) {
        //     re $e;
        // }
    }

//store in city supplier table

    public function storeReviewedHotels()
    {
        $reviwed_hotels = DB::table('wow_supplier_hotel_reviewed')->get();
        foreach ($reviwed_hotels as $hotel) {
            DB::table('wow_supplier_hotel')->updateOrInsert(
                [
                    'supplier_id' => $hotel->supplier_id,
                    'hotel_id' => $hotel->wow_hotel_id,
                ],
                [
                    'hotel_code' => $hotel->supplier_hotel_code,
                ]
            );
        }
    }
}
