<?php

namespace Modules\Common\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Common\Entities\Notification;

class NotificationsController extends Controller
{
    public function list(Request $req)
    {
        $notifications = Notification::
            //when log dates
            when($req->date, function ($query) use ($req) {
                $date = explode('~', $req->date);
                return $query->whereBetween('created_at', [Carbon::parse($date[0])->format('Y-m-d'), Carbon::parse($date[1])->format('Y-m-d')]);
            })
            //when request has method
            ->when($req->type != 'all', function ($query) use ($req) {
                return $query->where('type', $req->type);
            })
            ->orderBy('created_at', 'DESC')->jsonPaginate();
        return json_response_pagination($notifications);
    } 


}
