<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Reports\Http\Controllers\CanceledOrdersReportController;
use Modules\Reports\Http\Controllers\ClientsReportController;
use Modules\Reports\Http\Controllers\ConfirmedOrdersReportController;
use Modules\Reports\Http\Controllers\PaymentsReportController;
use Modules\Reports\Http\Controllers\ReportsController;
use Modules\Reports\Http\Controllers\SuppliersReportController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => 'reports', 'middleware' => ['has_permission', 'logger']], function () {
    //get modules and suppliers
    Route::get('/modules', [ReportsController::class, 'getModules'])->name('reports_modules');
    Route::post('/generate_report', [ReportsController::class, 'generate'])->name('reports_generate_reports');
});
