<?php

namespace Modules\Locales\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Modules\Locales\Entities\Continent;

class ContinentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function continents_list()
    {
        $path = base_path() . '/Modules/Locales/Resources/Continent/continents.json';
        $continents = json_decode(file_get_contents($path), true);
        return $continents;
    }

    public function run()
    {
        $continents = $this->continents_list();
        foreach ((array)$continents as $city) {
            Continent::Create($city);
        }
    }

}
