<?php

namespace Modules\Hotels\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Users\Entities\User;

class Hotel extends Model
{
    protected $table = 'hotels_booking_list';

    protected $fillable = [
        'user_id',
        'company_id',
        'wow_merchant_ref',
        'payment_status' ,
        'payment_deadline',
        'supplier_booking_id',
        'supplier_name',
        'supplier_ref_number',
        'amendment_status',
        'booking_status' ,
        'voucher_status' ,
        'confirmation_number',
        'invoice_number' ,
        'hotel_id',
        'trip_name',
        'hotel_name' ,
        'hotel_rating',
        'city_code',
        'city_name',
        'from_date',
        'to_date',
        'last_cancellation_deadline' ,
        'current_cancellation_charge',
        'rooms_number',
        'rooms_type_name',
        'currency_code',
        'amount' ,
        'original_amount' ,
        'booking_date',
        'booking_details',
        'hotel'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [];

    protected $casts = [
        'is_deleted' => 'boolean',
        'booking_details' => 'array',
        'hotel' => 'array',
    ];

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function company()
    {
        return $this->hasOne(User::class, 'id', 'company_id');
    }
}
