<?php

use GuzzleHttp\Middleware;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Flights\Http\Controllers\FlightsController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('/flights', function (Request $request) {
//     return $request->user();
// });

Route::post('flights/ticket_push', [FlightsController::class, 'PkFareTicketPush'])->name('flights_ticket_push');

// Route::group(['prefix' => 'flights', 'middleware' => ['has_permission', 'logger', 'language']], function () {
Route::group(['prefix' => 'flights', 'middleware' => ['has_permission', 'language']], function () {
    // Route::group(['prefix' => 'flights'], function(){
    Route::get('/auto_complete/{query}', [FlightsController::class, 'auto_complete'])->name('flights_auto_complete');
    Route::post('/search', [FlightsController::class, 'search'])->name('flights_search');
    Route::post('/select_flight', [FlightsController::class, 'select_flight'])->name('flights_select_flight');
    Route::post('/pricing', [FlightsController::class, 'pricing'])->name('flights_pricing');
    Route::post('/book', [FlightsController::class, 'book'])->name('flights_book');
    // Route::post('/booking_details', [FlightsController::class,'booking_details'])->name('flights_booking_details');
    Route::get('/local_booking_details/{merchant_ref}', [FlightsController::class, 'local_booking_details'])->name('flights_local_booking_details');
    Route::get('/booking_list', [FlightsController::class, 'booking_list'])->name('flights_booking_list');
    Route::get('/local_booking_list', [FlightsController::class, 'local_booking_list'])->name('flights_local_booking_list');
    Route::get('/pre_payment/{merchant_ref}', [FlightsController::class, 'pre_payment'])->name('flights_pre_payment');
    Route::post('/pay_from_balance/{merchant_ref}', [FlightsController::class, 'pay_from_balance'])->name('flights_pay_from_balance');
    Route::get('/payment_details/{merchant_ref}', [FlightsController::class, 'payment_details'])->name('flights_payment_details');
    Route::get('/booking_details/{merchant_ref}', [FlightsController::class, 'booking_details'])->name('flights_booking_details');
    Route::get('/country_list', [FlightsController::class, 'country_list'])->name('flights_country_list');
    Route::get('/nationality_list', [FlightsController::class, 'nationality_list'])->name('flights_nationality_list');
    Route::post('/book', [FlightsController::class, 'book'])->name('flights_book');

    Route::get('/cancel_booking/{merchant_ref}', [FlightsController::class, 'cancel_booking'])->name('flights_cancel_booking');
});
