<?php

namespace Modules\Flights\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Payments\Entities\Payment;
use Modules\Users\Entities\User;

class Flight extends Model
{
    protected $table = 'flights_booking_list';

    protected $fillable = [
        'user_id',
        'company_id',
        'wow_merchant_ref',
        'supplier_name',
        'adult_count',
        'child_count',
        'infant_count',
        'user_data',
        'email',
        'title',
        'first_name',
        'last_name',
        'mobile',
        'payment_status',
        'payment_deadline',
        'booking_status',
        'ticket_status',
        'booking_details',
        'pnr',
        'ip_address',
        'is_lcc',
        'is_refund_allowed',
        'is_reissue_allowed',
        'is_online_refund_allowed',
        'is_void_allowed',
        'amount',
        'currency_code',
        'original_amount'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [];

    protected $casts = [
        'is_deleted' => 'boolean',
        'mobile' => 'array',
        'booking_details' => 'array'
    ];
    public function User()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function company()
    {
        return $this->hasOne(User::class, 'id', 'company_id');
    }

    public function payment()
    {
        return $this->hasOne(Payment::class, 'id', 'payment_id');
    }
}
