<?php

use App\Http\Controllers\Admin\UsersController;
use App\Http\Controllers\Admin\RolesController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\MarkupController;
use App\Http\Controllers\Admin\SuppliersController;
use App\Http\Controllers\ModulesController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth:sanctum', 'verified', 'permissions'])->prefix('admin')->group(function () {

	/*Route for users*/
	Route::get('/', [DashboardController::class, 'dashboard']);
	Route::get('/dashboard', [DashboardController::class, 'dashboard'])->name('admin.dashboard');
	Route::get('/users', [UsersController::class, 'index'])->name('admin.users.index');
	Route::get('/users/create', [UsersController::class, 'create'])->name('admin.users.create');
	Route::post('/users/store', [UsersController::class, 'store'])->name('admin.users.store');
	Route::get('/users/edit/{id}', [UsersController::class, 'edit'])->name('admin.users.edit');
	Route::post('/users/update/{id}', [UsersController::class, 'update'])->name('admin.users.update');
	Route::get('/users/delete/{id}', [UsersController::class, 'destroy'])->name('admin.users.delete');
	Route::post('/users/update-password/{id}', [UsersController::class, 'update_password'])->name('admin.users.update-password');
	Route::post('/users/update-roles/{id}', [UsersController::class, 'update_user_roles'])->name('admin.users.update_user_roles');
	Route::post('/users/update_agent_token/{user}', [UsersController::class, 'update_agent_token'])->name('admin.users.update_agent_token');
	Route::post('/users/update-modules-and-suppliers/{id}', [UsersController::class, 'update_user_modules_and_supplier'])->name('admin.users.update_user_modules_and_supplier');
	Route::match(['get', 'post'], '/profile', [UsersController::class, 'profile'])->name('admin.users.profile');
	Route::get('user/remove_image/{id}', [UsersController::class, 'remove_user_image'])->name('admin.user.remove_user_image');

	/*Route for Roles*/
	Route::get('/roles', [RolesController::class, 'index'])->name('admin.roles.index');
	Route::get('/roles/create', [RolesController::class, 'create'])->name('admin.roles.create');
	Route::post('/roles/store', [RolesController::class, 'store'])->name('admin.roles.store');
	Route::get('/roles/edit/{id}', [RolesController::class, 'edit'])->name('admin.roles.edit');
	Route::post('/roles/update/{id}', [RolesController::class, 'update'])->name('admin.roles.update');
	Route::get('/roles/delete/{id}', [RolesController::class, 'destroy'])->name('admin.roles.delete');

	/*Route for Suppliers*/
	Route::get('/suppliers', [SuppliersController::class, 'index'])->name('admin.suppliers.index');
	Route::get('/suppliers/create', [SuppliersController::class, 'create'])->name('admin.suppliers.create');
	Route::post('/suppliers/store', [SuppliersController::class, 'store'])->name('admin.suppliers.store');
	Route::get('/suppliers/edit/{id}', [SuppliersController::class, 'edit'])->name('admin.suppliers.edit');
	Route::post('/suppliers/update/{id}', [SuppliersController::class, 'update'])->name('admin.suppliers.update');
	Route::get('/suppliers/delete/{id}', [SuppliersController::class, 'destroy'])->name('admin.suppliers.delete');

	/*Route for Suppliers*/
	Route::get('/modules', [ModulesController::class, 'index'])->name('admin.modules.index');
	Route::get('/modules/create', [ModulesController::class, 'create'])->name('admin.modules.create');
	Route::post('/modules/store', [ModulesController::class, 'store'])->name('admin.modules.store');
	Route::get('/modules/edit/{id}', [ModulesController::class, 'edit'])->name('admin.modules.edit');
	Route::post('/modules/update/{id}', [ModulesController::class, 'update'])->name('admin.modules.update');
	Route::get('/modules/delete/{id}', [ModulesController::class, 'destroy'])->name('admin.modules.delete');

	/*Route for Markup*/
	Route::get('/markup', [MarkupController::class, 'index'])->name('admin.markup.index');
	Route::get('/markup/edit/{id}', [MarkupController::class, 'edit'])->name('admin.markup.edit');
	Route::post('/markup/update/{id}', [MarkupController::class, 'update'])->name('admin.markup.update');
	Route::post('/markup/get-supplier-form', [MarkupController::class,'get_supplier_form'])->name('get-supplier-form');
	Route::get('/markup/delete/{id}', [MarkupController::class, 'destroy'])->name('admin.markup.delete');
});
