{{-- Extends layout --}}
@extends('admin.layout.default')
{{-- Content --}}
@section('content')
    <div class="container-fluid">
        <div class="row page-titles mx-0 mb-3">
            <div class="col-sm-6 p-0">
                <div class="welcome-text">
                    <h4>{{ __('Agents') }}</h4>
                    <span>{{ __('All Agents list') }}</span>
                </div>
            </div>
            <div class="col-sm-6 p-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.markup.index') }}">{{ __('Agents') }}</a></li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">{{ __('All Agents') }}</a></li>
                </ol>
            </div>
        </div>

        @php
            $collapsed = 'collapsed';
            $show = '';
        @endphp

        <div class="row">
            <div class="col-xl-12">
                <div class="card accordion accordion-rounded-stylish accordion-bordered" id="search-sec-outer">
                    <div class="accordion-header rounded-lg {{ $collapsed }}" data-bs-toggle="collapse"
                        data-bs-target="#rounded-search-sec">
                        <span class="accordion-header-icon"></span>
                        <h4 class="accordion-header-text m-0">{{ __('Filter') }}</h4>
                        <span class="accordion-header-indicator"></span>
                    </div>
                    <div class="card-body collapse accordion__body {{ $show }}" id="rounded-search-sec"
                        data-bs-parent="#search-sec-outer">
                        {{ Form::model(request()->all(), ['route' => ['admin.markup.index'], 'method' => 'get']) }}
                        <input type="hidden" name="todo" value="Filter">
                        <div class="row">
                            <div class="form-group col-sm-6 col-md-3 col-lg-4 col-xl-3">
                                {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => __('Name')]) }}
                            </div>
                            <div class="form-group col-sm-6 col-md-3 col-lg-4 col-xl-3">
                                {{ Form::email('email', null, ['class' => 'form-control', 'placeholder' => __('Email')]) }}
                            </div>

                            <div class=" col-sm-6 col-md-3 col-lg-4 col-xl-3 text-sm-end">
                                <input type="submit" name="search" value="{{ __('Search') }}"
                                    class="btn btn-primary me-2"> <a href="{{ route('admin.markup.index') }}"
                                    class="btn btn-danger">{{ __('Reset') }}</a>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>

        <!-- row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Agents') }}</h4>
                    </div>
                    <div class="pe-4 ps-4 pt-2 pb-2">
                        <div class="table-responsive">
                            <table class="table table-responsive-lg mb-0">
                                <thead>
                                    <tr>
                                        <th> <strong> {{ __('SN.') }} </strong> </th>
                                        <th> <strong> {{ __('Profile') }} </strong> </th>
                                        <th> <strong> {!! DzHelper::dzSortable('name', __('Name')) !!} </strong> </th>
                                        <th> <strong> {!! DzHelper::dzSortable('email', __('Email')) !!} </strong> </th>
                                        <th> <strong> {!! DzHelper::dzSortable('status', __('Status')) !!} </strong> </th>
                                        <th> <strong> {{ __('markup') }}</strong> </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $i = $users->firstItem();
                                    @endphp
                                    @forelse ($users as $user)
                                        <tr>
                                            <td> {{ $i++ }} </td>
                                            <td>
                                                <img class="rounded" src="{{ HelpDesk::user_img($user->profile) }}"
                                                    alt="{{ $user->profile }}" width="50px" height="50px">
                                            </td>
                                            <td> {{ $user->name }} </td>
                                            <td> {{ $user->email }} </td>
                                            <td> {{ $user->status ? __('web.active') : __('web.in_active') }} </td>
                                            <td>
                                                @can('Controllers > MarkupController>edit')
                                                    <a href="{{ route('admin.markup.edit', $user->id) }}"
                                                        class="btn btn-primary shadow btn-xs sharp ms-4"><i
                                                            class="fas fa-pencil-alt"></i></a>
                                                @endcan
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center">{{ __('No Agents') }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer">
                        {{ $users->appends(Request::input())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
