{{-- Extends layout --}}
@extends('admin.layout.default')

{{-- Content --}}
@section('content')
    <div class="container-fluid">
        <div class="row page-titles mx-0 mb-3">
            <div class="col-sm-6 p-0">
                <div class="welcome-text">
                    <h4>{{ __('Agent Markup') }}</h4>
                    <span>{{ __('Edit Agent Markup') }}</span>
                </div>
            </div>
            <div class="col-sm-6 p-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.markup.index') }}">{{ __('Agents Markup') }}</a></li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">{{ __('Edit Agent Markup') }}</a></li>
                </ol>
            </div>
        </div>
        <form action="{{ route('admin.markup.update', $agent->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            {{-- Agent Markup  --}}

            <div class="card">
                <div class="card-header">
                    <h3>{{ __('Agent Markup') }}</h3>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <div class="row">
                            <div class="row">
                                <div class="form-group col-md-2">
                                    <div class="form-group">
                                        <label for="markup_type">{{ __('Markup Type') }}</label>
                                        <select name="agent[markup_type]" id="markup_type_agent" class="form-control"
                                            onchange="handleMarkupTypeChange('agent')">
                                            <option value="fixed"
                                                {{ $agent_markup['markup_type'] == 'fixed' ? 'selected' : '' }}>
                                                {{ __('Fixed') }}</option>
                                            <option {{ $agent_markup['markup_type'] == 'percentage' ? 'selected' : '' }}
                                                value="percentage">{{ __('Percentage') }}</option>
                                            <option {{ $agent_markup['markup_type'] == 'both' ? 'selected' : '' }}
                                                value="both">{{ __('Both') }}</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-5">
                                    <div class="form-group" id="fixed_amount_agent"
                                        style="{{ !isset($agent_markup['fixed_amount']) ? 'display: none;' : '' }}">
                                        <label for="fixed_amount">{{ __('Fixed Amount') }}</label>
                                        <input type="number" name="agent[fixed_amount]" class="form-control"
                                            value={{ $agent_markup['fixed_amount'] }}>
                                        @error('fixed_amount')
                                            <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group col-md-5">
                                    <div class="form-group" id="percentage_amount_agent"
                                        style="{{ !isset($agent_markup['percentage']) ? 'display: none;' : '' }}">
                                        <label for="percentage">{{ __('Percentage') }}</label>
                                        <input type="number" name="agent[percentage]" class="form-control"
                                            value={{ $agent_markup['percentage'] }}>
                                        @error('percentage')
                                            <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group col-md-5">
                                    <input type="checkbox" name="agent[cut_off]" id="cut-off"
                                        {{ isset($agent_markup['cut_off']) && $agent_markup['cut_off'] ? 'checked' : '' }}>
                                    <label for="cut-off">{{ __('Cut off') }}</label>
                                    <p class="note">{{ __('Check this to apply cut-off or leave it a commission.') }}</p>
                                </div>

                                <div class="form-group col-md-6">
                                    <input type="checkbox" name="agent[over_write]" id="over_write"
                                        {{ isset($agent_markup['over_write']) && $agent_markup['over_write'] ? 'checked' : '' }}>
                                    <label for="over_write">{{ __('overwrite') }}</label>
                                    <p class="note">
                                        {{ __('Check this to apply overwrite over other markups for this agent.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- modules and suppliers markup  --}}

            <div class="col-md-12">
                @foreach ($modules as $module)
                    @php
                        $suppliers = $module->suppliers ?? [];
                    @endphp
                    @if (in_array($module->id, $userModules))
                        <div class="card">
                            <div class="card-header">
                                <h3>{{ $module->name . ' ' . __('Module Markup') }}</h3>
                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                    <div class="row">
                                        <div class="tab-pane fade show active" id="moduleTabContent_{{ $module->id }}"
                                            role="tabpanel" aria-labelledby="moduleTab_{{ $module->id }}">
                                            @php
                                                $formTemplateName = 'admin.markup.forms.' . $module->key . '_module';
                                            @endphp
                                            @if (view()->exists($formTemplateName))
                                                @include($formTemplateName, [
                                                    'module' => $module,
                                                    'markup' => $module->getModuleMarkupSettingsAttribute(
                                                        $agent->id),
                                                ])
                                            @else
                                                <p>{{ __('Form not found') }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <h4>{{ __('Module Suppliers Markup') }}</h4>
                                <div class="col-12 ms-4">
                                    <ul class="nav nav-tabs" id="supplierTabs_{{ $module->id }}" role="tablist">
                                        @php $i = 0 @endphp
                                        @foreach ($suppliers as $index => $supplier)
                                            @if (in_array($supplier->id, $userSuppliers))
                                                <li class="nav-item" role="presentation">
                                                    <button class="nav-link{{ $i === 0 ? ' active' : '' }}"
                                                        id="supplierTab_{{ $supplier->id }}" data-bs-toggle="tab"
                                                        data-bs-target="#supplierTabContent_{{ $supplier->id }}"
                                                        type="button" role="tab"
                                                        aria-controls="supplierTabContent_{{ $supplier->id }}">
                                                        {{ $supplier->name }}
                                                    </button>
                                                </li>
                                                @php $i++ @endphp
                                            @endif
                                        @endforeach
                                    </ul>

                                    <div class="tab-content" id="supplierTabContent_{{ $module->id }}">
                                        @php $i = 0 @endphp
                                        @foreach ($suppliers as $index => $supplier)
                                            @if (in_array($supplier->id, $userSuppliers))
                                                <div class="tab-pane fade{{ $i === 0 ? ' show active' : '' }}"
                                                    id="supplierTabContent_{{ $supplier->id }}" role="tabpanel"
                                                    aria-labelledby="supplierTab_{{ $supplier->id }}">
                                                    <div class="card-body col-12">
                                                        @php
                                                            $formTemplateName = 'admin.markup.forms.' . $supplier->module->key . '_supplier';
                                                        @endphp
                                                        @if (view()->exists($formTemplateName))
                                                            @include($formTemplateName, [
                                                                'supplier' => $supplier,
                                                                'module' => $module,
                                                                'markup' => $supplier->getSupplierMarkupSettingsAttribute(
                                                                    $agent->id),
                                                            ])
                                                        @else
                                                            <p>{{ __('Form not found') }}</p>
                                                        @endif
                                                    </div>
                                                </div>
                                                @php $i++ @endphp
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                <a href="{{ route('admin.markup.index') }}" class="btn btn-danger">{{ __('Cancel') }}</a>
            </div>
        </form>
    </div>
@endsection

@push('inline-scripts')
    <script>
        function handleMarkupTypeChange(id) {
            var selectedValue = document.getElementById("markup_type_" + id).value;
            const fixedMarkupInput = document.getElementById('fixed_amount_' + id);
            const percentageMarkupInput = document.getElementById('percentage_amount_' + id);
            // Perform actions based on the selected value
            switch (selectedValue) {
                case "fixed":
                    // Code to handle the "Fixed" markup type
                    fixedMarkupInput.style.display = 'block'; // Show the fixed markup input
                    percentageMarkupInput.style.display = 'none'; // Hide the percentage markup input
                    break;
                case "percentage":
                    // Code to handle the "Percentage" markup type
                    fixedMarkupInput.style.display = 'none'; // Hide the fixed markup input
                    percentageMarkupInput.style.display = 'block'; // Show the percentage markup input
                    break;
                case "both":
                    // Code to handle the "Both" markup type
                    fixedMarkupInput.style.display = 'block'; // Show both input options
                    percentageMarkupInput.style.display = 'block';
                    break;
                default:
                    // Handle default case if needed
                    fixedMarkupInput.style.display = 'none'; // Hide both input options
                    percentageMarkupInput.style.display = 'none';
                    break;
            }
        }

        function toggleSupplierForm(supplierId, agentId) {
            const formContainer = document.getElementById(`supplierFormContainer_${supplierId}`);
            // If the container is empty, load the form; otherwise, clear the content
            if (formContainer.innerHTML.trim() === '') {
                loadSupplierForm(supplierId, agentId, formContainer);
            } else {
                formContainer.innerHTML = '';
            }
        }

        function loadSupplierForm(supplierId, agentId) {
            const formContainer = document.getElementById(`supplierFormContainer_${supplierId}`);
            // Construct the payload data
            const payload = {
                agent_id: agentId,
                supplier_id: supplierId
            };
            // Load the form content using an HTTP POST request
            fetch('/admin/markup/get-supplier-form', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify(payload)
                })
                .then(response => response.text())
                .then(data => {
                    formContainer.innerHTML = data; // Insert the form content
                })
                .catch(error => {
                    console.error('Error loading form:', error);
                });
        }
    </script>
@endpush
