<!--**********************************
 Sidebar Fixed
***********************************-->

@php
    $current_user = auth()->user();
    $user_name = isset($current_user->full_name) ? $current_user->full_name : '';
    $user_email = isset($current_user->email) ? $current_user->email : '';
    $userId = isset($current_user->id) ? $current_user->id : '';
    $userImg = HelpDesk::user_img($current_user->profile);
@endphp

@php
    $sub_menu_icon =
        '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><polygon points="0 0 24 0 24 24 0 24"/><path d="M22,15 L22,19 C22,20.1045695 21.1045695,21 20,21 L8,21 C5.790861,21 4,19.209139 4,17 C4,14.790861 5.790861,13 8,13 L20,13 C21.1045695,13 22,13.8954305 22,15 Z M7,19 C8.1045695,19 9,18.1045695 9,17 C9,15.8954305 8.1045695,15 7,15 C5.8954305,15 5,15.8954305 5,17 C5,18.1045695 5.8954305,19 7,19 Z" fill="#000000" opacity="0.3"/><path d="M15.5421357,5.69999981 L18.3705628,8.52842693 C19.1516114,9.30947552 19.1516114,10.5758055 18.3705628,11.3568541 L9.88528147,19.8421354 C8.3231843,21.4042326 5.79052439,21.4042326 4.22842722,19.8421354 C2.66633005,18.2800383 2.66633005,15.7473784 4.22842722,14.1852812 L12.7137086,5.69999981 C13.4947572,4.91895123 14.7610871,4.91895123 15.5421357,5.69999981 Z M7,19 C8.1045695,19 9,18.1045695 9,17 C9,15.8954305 8.1045695,15 7,15 C5.8954305,15 5,15.8954305 5,17 C5,18.1045695 5.8954305,19 7,19 Z" fill="#000000" opacity="0.3"/><path d="M5,3 L9,3 C10.1045695,3 11,3.8954305 11,5 L11,17 C11,19.209139 9.209139,21 7,21 C4.790861,21 3,19.209139 3,17 L3,5 C3,3.8954305 3.8954305,3 5,3 Z M7,19 C8.1045695,19 9,18.1045695 9,17 C9,15.8954305 8.1045695,15 7,15 C5.8954305,15 5,15.8954305 5,17 C5,18.1045695 5.8954305,19 7,19 Z" fill="#000000"/></g></svg>';
@endphp

<div class="deznav">
    <div class="deznav-scroll">
        <div class="main-profile">
            <div class="image-bx">
                <img src="{{ $userImg }}" alt="{{ __('User profile') }}">
                <a href="{!! route('admin.users.profile') !!}"><i class="fa fa-cog" aria-hidden="true"></i></a>
            </div>
            <h5 class="name"><span class="font-w400">{{ __('Hello,') }}</span> {{ $user_name }}</h5>
            <p class="email">{{ $user_email }}</p>
        </div>
        <ul class="metismenu" id="menu">

            {{-- @can('Controllers > DashboardController > dashboard')
                <li>
                    <a class="has-arrow ai-icon" href="javascript:void()" aria-expanded="false">
                        <i class="flaticon-141-home"></i>
                        <span class="nav-text">{{ __('Dashboard') }}</span>
                    </a>
                    <ul aria-expanded="false">
                        <li class="{{ request()->is('admin') ? 'mm-active' : '' }}">
                            <a href="{!! url('/admin') !!}">{{ __('Dashboard') }}</a>
                        </li>
                    </ul>
                </li>
            @endcan --}}

            <li class="nav-label">{{ __('Modules And Suppliers') }}</li>
            @can('Controllers>ModulesController>index')
                <li>
                    <a class="{{-- has-arrow --}} ai-icon" href="{{ route('admin.modules.index') }}"
                        aria-expanded="false">
                        <i class="flaticon-028-user-1"></i>
                        <span class="nav-text">{{ __('Modules') }}</span>
                    </a>

                </li>
            @endcan
            @can('Controllers>SupplierContoller>index')
                <li>
                    <a class="{{-- has-arrow --}} ai-icon" href="{{ route('admin.suppliers.index') }}"
                        aria-expanded="false">
                        <i class="flaticon-028-user-1"></i>
                        <span class="nav-text">{{ __('Suppliers') }}</span>
                    </a>

                </li>
            @endcan

            <li class="nav-label">{{ __('Agents Management') }}</li>

            @can('Controllers > UsersController > index')
                <li>
                    <a class="ai-icon" href="{{ route('admin.users.index') }}" aria-expanded="false">
                        <i class="flaticon-028-user-1"></i>
                        <span class="nav-text">{{ __('Agents') }}</span>
                    </a>
                </li>
            @endcan

            @can('Controllers > MarkupContoller > index')
                <li>
                    <a class="ai-icon" href="{{ route('admin.markup.index') }}" aria-expanded="false">
                        <i class="flaticon-028-user-1"></i>
                        <span class="nav-text">{{ __('Agents Markup') }}</span>
                    </a>
                </li>
            @endcan

            @canany(['Controllers > RolesController > index', 'Controllers > RolesController > create'])
                <li>
                    <a class="ai-icon" href="{{ route('admin.roles.index') }}" aria-expanded="false">
                        <i class="flaticon-153-user"></i>
                        <span class="nav-text">{{ __('Roles') }}</span>
                    </a>
                </li>
            @endcanany

            @canany([
                'Controllers > PermissionsController > index',
                'Controllers > PermissionsController >
                roles_permissions',
                'Controllers > PermissionsController > user_permissions',
                'Controllers >
                PermissionsController > temp_permissions',
                ])
                <li>
                    <a class="has-arrow ai-icon" href="javascript:void()" aria-expanded="false">
                        <i class="flaticon-035-shield"></i>
                        <span class="nav-text">{{ __('Permissions') }}</span>
                    </a>
                    <ul aria-expanded="false">
                        @can('Controllers > PermissionsController > index')
                            <li><a href="{{ route('admin.permissions.index') }}">{{ __('All Permissions') }}</a></li>
                        @endcan
                        @can('Controllers > PermissionsController > temp_permissions')
                            <li><a
                                    href="{{ route('admin.permissions.temp_permissions') }}">{{ __('All Temp Permissions') }}</a>
                            </li>
                        @endcan
                        @can('Controllers > PermissionsController > roles_permissions')
                            <li><a href="{{ route('admin.permissions.roles_permissions') }}">{{ __('Roles Permissions') }}</a>
                            </li>
                        @endcan
                        @can('Controllers > PermissionsController > user_permissions')
                            <li><a href="{{ route('admin.permissions.user_permissions') }}">{{ __('Users Permissions') }}</a>
                            </li>
                        @endcan
                    </ul>
                </li>
            @endcanany

            @can('Modules>StaticData>Http>Controllers>StaticDataController>index')
                <li class="nav-label">{{ __('Static Data') }}</li>
                @can('Controllers > CountriesController > index')
                    <li>
                        <a class="has-arrow ai-icon" href="{{ route('static_data.countries.index') }}" aria-expanded="false">
                            <i class="flaticon-028-user-1"></i>
                            <span class="nav-text">{{ __('Countries') }}</span>
                        </a>
                    </li>
                @endcan
                @can('Controllers > CitiesController > index')
                    <li>
                        <a class="has-arrow ai-icon" href="{{-- {{ route('static_data.cities.index') }} --}}" aria-expanded="false">
                            <i class="flaticon-028-user-1"></i>
                            <span class="nav-text">{{ __('Cities') }}</span>
                        </a>
                    </li>
                @endcan
                @can('Controllers > HotelsController > index')
                    <li>
                        <a class="has-arrow ai-icon" href="{{-- {{ route('static_data.hotels.index') }} --}}" aria-expanded="false">
                            <i class="flaticon-028-user-1"></i>
                            <span class="nav-text">{{ __('Hotels') }}</span>
                        </a>
                    </li>
                @endcan
                @can('Controllers > AirlinesController > index')
                    <li>
                        <a class="has-arrow ai-icon" href="{{-- {{ route('static_data.airlines.index') }} --}}" aria-expanded="false">
                            <i class="flaticon-028-user-1"></i>
                            <span class="nav-text">{{ __('Airlines') }}</span>
                        </a>
                    </li>
                @endcan

                @can('Controllers > AirportsController > index')
                    <li>
                        <a class="has-arrow ai-icon" href="{{-- {{ route('static_data.airports.index') }} --}}" aria-expanded="false">
                            <i class="flaticon-028-user-1"></i>
                            <span class="nav-text">{{ __('Airports') }}</span>
                        </a>
                    </li>
                @endcan

            @endcan

            @php
                $configuration_menu = HelpDesk::configuration_menu();
            @endphp

            @if (!empty($configuration_menu))
                <li>
                    <a class="has-arrow ai-icon" href="{{ route('admin.configurations.admin_prefix', 'site') }}"
                        aria-expanded="false">
                        <i class="flaticon-073-settings"></i>
                        <span class="nav-text">{{ __('Site Configuration') }}</span>
                    </a>
                </li>
            @endif

        </ul>
        <div class="copyright">
        </div>
    </div>
</div>

<!--**********************************
 Sidebar End
***********************************
