<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Module extends Model
{
    use HasFactory;
    protected $table = 'modules';
    protected $fillable = [
        'name',
        'desc',
        'key',
        'weight',
        'status'
    ];

    public function suppliers()
    {
        return $this->hasMany(Supplier::class);
    }
    public function getModuleMarkupSettingsAttribute($agent_id)
    {
        $module = Markup::where('agent_id', $agent_id)->where('type', Markup::Type_Module)->where('module_id', $this->id)->first();
        return $module->data ?? [];
    }
}
