<?php

use App\Models\UserCredit;

function update_credits($user_id, $amount)
{
    try {
        UserCredit::where('user_id', $user_id)->update([
            'credit_amount' => $amount
        ]);
    } catch (Exception $e) {
        throw new Exception('error saving company credit amount' . $e->getMessage());
    }
}

function pay_from_credits($company, $amount_to_pay)
{
    $user_credits = $company->balance;
    $net = $user_credits->credit_amount - $amount_to_pay;

    if ($net >= $user_credits->credit_allowed_amount) {
        update_credits($company->id, $net);
        return 0;
    } else {
        $remaining = calculate_remaining_credits($user_credits, $amount_to_pay);
        return $remaining;
    }
}


function calculate_remaining_credits($user_credits, $amount_to_pay)
{
    $remaining = $user_credits->credit_amount - $user_credits->credit_allowed_amount;
    return  $amount_to_pay - $remaining;
}
