<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Modules\StaticData\Http\Controllers\CountriesController;

Route::middleware(['auth:sanctum', 'verified', 'permissions'])->prefix('static_data')->group(function () {
    Route::get('/countries', [CountriesController::class, 'index'])->name('static_data.countries.index');
    Route::get('/countries/create', [CountriesController::class, 'create'])->name('static_data.countries.create');
    Route::post('/countries/store', [CountriesController::class, 'store'])->name('static_data.countries.store');
    Route::get('/countries/edit/{id}', [CountriesController::class, 'edit'])->name('static_data.countries.edit');
    Route::post('/countries/update/{id}', [CountriesController::class, 'update'])->name('static_data.countries.update');
    Route::get('/countries/delete/{id}', [CountriesController::class, 'destroy'])->name('static_data.countries.delete');
});
