<?php

namespace Modules\Hotels\Http\Controllers\SDK\Tbo;

use DOMDocument;
use Exception;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Crypt;

class TboSdkController extends Controller
{
    protected $username;
    protected $password;
    protected $search_response_timeout;
    public function __construct($settings)
    {
        $this->username = Crypt::decryptString($settings['Username']);
        $this->password = Crypt::decryptString($settings['Password']);
        $this->search_response_timeout = Crypt::decryptString($settings['SearchResponseTimeout']);
    }

    // public function hotelSearchCurlHandle($params)
    // {
    //     ini_set('max_execution_time', -1);
    //     $xml = new DOMDocument("1.0", "UTF-8");
    //     $xml_env = $xml->createElement("soap:Envelope");
    //     $xml_env->setAttribute("xmlns:soap", "http://www.w3.org/2003/05/soap-envelope");
    //     $xml_env->setAttribute("xmlns:hot", "http://TekTravel/HotelBookingApi");
    //     /*create header*/
    //     $xml_hed = $xml->createElement("soap:Header");
    //     $xml_hed->setAttribute("xmlns:wsa", "http://www.w3.org/2005/08/addressing");

    //     $xml_cred = $xml->createElement("hot:Credentials");
    //     $xml_cred->setAttribute("UserName", $this->username);
    //     $xml_cred->setAttribute("Password", $this->password);

    //     $xml_wsaa = $xml->createElement("wsa:Action", "http://TekTravel/HotelBookingApi/HotelSearch");
    //     $xml_wsat = $xml->createElement("wsa:To", "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc");

    //     $xml_hed->appendChild($xml_cred);
    //     $xml_hed->appendChild($xml_wsaa);
    //     $xml_hed->appendChild($xml_wsat);
    //     $xml_env->appendChild($xml_hed);

    //     /*create body*/
    //     $xml_bdy = $xml->createElement("soap:Body");
    //     $xml_bdyreq = $xml->createElement("hot:HotelSearchRequest");
    //     $xml_bdyreqele = $xml->createElement("hot:CheckInDate", $params['Checkin']);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:CheckOutDate", $params['Checkout']);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:CountryName", $params['countryName']);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:CityName", $params['cityName']);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:CityId", $params['cityCode']);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:IsNearBySearchAllowed", "false");
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:IsRoomInfoRequired", "true");
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:NoOfRooms", count($params['Rooms']));
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:GuestNationality", $params['guestNationality']);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:RoomGuests");
    //     $rooms = $params['Rooms'];
    //     if (!empty($rooms) && count($rooms) > 0) {
    //         for ($i = 0; $i < count($rooms); $i++) {
    //             $room_adults_count = $rooms[$i]["adults"];

    //             $room_children_count = $rooms[$i]["children"];
    //             $xml_bdyreqinnerele = $xml->createElement("hot:RoomGuest");
    //             if ($room_adults_count > 0) {
    //                 $xml_bdyreqinnerele->setAttribute("AdultCount", $room_adults_count);
    //             }

    //             $xml_bdyreqinnerele->setAttribute("ChildCount", $room_children_count);

    //             if ($room_children_count > 0) {
    //                 for ($x = 0; $x < count($rooms[$i]["children_ages"]); $x++) {
    //                     $xml_bdyreqinnerele2 = $xml->createElement("hot:ChildAge");
    //                     $xml_bdyreqinnerele3 = $xml->createElement("hot:int", $rooms[$i]["children_ages"][$x]);
    //                     $xml_bdyreqinnerele2->appendChild($xml_bdyreqinnerele3);
    //                     $xml_bdyreqinnerele->appendChild($xml_bdyreqinnerele2);
    //                 }
    //             }
    //             $xml_bdyreqele->appendChild($xml_bdyreqinnerele);
    //         }
    //     }

    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     /**
    //      * !important don't hardcode currency code
    //      */
    //     $xml_bdyreqele = $xml->createElement("hot:PreferredCurrencyCode", 'USD');
    //     // $xml_bdyreqele = $xml->createElement( "hot:PreferredCurrencyCode", $currency_code);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:ResultCount", $params['resultLimit']);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:ResponseTime", $this->search_response_timeout);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdyreqele = $xml->createElement("hot:Filters");
    //     // $hotel_codes_string = implode(',', $parmas['HotelCodes'];
    //     // if ($cityCode != '113116') {
    //     $hotel_codes_string = "1376565,1345318,1345320,1200255,1128760,1250333,1078234,1347149,1358855,1345321,1108025,1356271,1267547"; //TEST CASE
    //     // }
    //     $xml_bdyreqinnerele2 = $xml->createElement("hot:HotelCodeList", $hotel_codes_string);
    //     $xml_bdyreqele->appendChild($xml_bdyreqinnerele2);

    //     $xml_bdyreqinnerele = $xml->createElement("hot:StarRating", "All");
    //     $xml_bdyreqinnerele = $xml->createElement("hot:OrderBy", "PriceDesc");
    //     $xml_bdyreqele->appendChild($xml_bdyreqinnerele);
    //     $xml_bdyreq->appendChild($xml_bdyreqele);

    //     $xml_bdy->appendChild($xml_bdyreq);
    //     $xml_env->appendChild($xml_bdy);

    //     $xml->appendChild($xml_env);
    //     $soap_request = $xml->saveXML();

    //     $myfile = fopen("hotel_search_request.xml", "w");
    //     fwrite($myfile, $soap_request);
    //     fclose($myfile);
    //     $WSDL = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";
    //     $user = $this->username;
    //     $password = $this->password;
    //     $ch = curl_init();
    //     curl_setopt($ch, CURLOPT_HEADER,         false);
    //     curl_setopt($ch, CURLOPT_URL,            $WSDL);
    //     curl_setopt($ch, CURLOPT_FAILONERROR,    true);
    //     curl_setopt($ch, CURLOPT_HTTPHEADER,     array(
    //         'Content-Type: application/soap+xml; charset=utf-8',
    //         'SOAPAction: "run"',
    //         'Accept: text/xml',
    //         'Cache-Control: no-cache',
    //         'Pragma: no-cache',
    //         'Content-length: ' . strlen($soap_request),
    //         'User-Agent: PHP-SOAP/7.0.10',
    //         'Accept-Encoding', 'gzip, deflate'
    //     ));
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    //     curl_setopt($ch, CURLOPT_USERPWD,        $user . ":" . $password);
    //     //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
    //     //curl_setopt($ch, CURLOPT_TIMEOUT,        30);
    //     curl_setopt($ch, CURLOPT_POSTFIELDS,     $soap_request);
    //     return $ch;
    // }

    // NODEJS FN
    public function hotelSearchCurlHandle($params)
    {
        ini_set('max_execution_time', -1);
        $xml = new DOMDocument("1.0", "UTF-8");
        $xml_env = $xml->createElement("soap:Envelope");
        $xml_env->setAttribute("xmlns:soap", "http://www.w3.org/2003/05/soap-envelope");
        $xml_env->setAttribute("xmlns:hot", "http://TekTravel/HotelBookingApi");
        /*create header*/
        $xml_hed = $xml->createElement("soap:Header");
        $xml_hed->setAttribute("xmlns:wsa", "http://www.w3.org/2005/08/addressing");

        $xml_cred = $xml->createElement("hot:Credentials");
        $xml_cred->setAttribute("UserName", $this->username);
        $xml_cred->setAttribute("Password", $this->password);

        $xml_wsaa = $xml->createElement("wsa:Action", "http://TekTravel/HotelBookingApi/HotelSearch");
        $xml_wsat = $xml->createElement("wsa:To", "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc");

        $xml_hed->appendChild($xml_cred);
        $xml_hed->appendChild($xml_wsaa);
        $xml_hed->appendChild($xml_wsat);
        $xml_env->appendChild($xml_hed);

        /*create body*/
        $xml_bdy = $xml->createElement("soap:Body");
        $xml_bdyreq = $xml->createElement("hot:HotelSearchRequest");
        $xml_bdyreqele = $xml->createElement("hot:CheckInDate", $params['Checkin']);
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:CheckOutDate", $params['Checkout']);
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:CountryName", $params['countryName']);
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:CityName", $params['cityName']);
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:CityId", $params['cityCode']);
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:IsNearBySearchAllowed", "false");
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:IsRoomInfoRequired", "true");
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:NoOfRooms", count($params['Rooms']));
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:GuestNationality", $params['guestNationality']);
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:RoomGuests");
        $rooms = $params['Rooms'];
        if (!empty($rooms) && count($rooms) > 0) {
            for ($i = 0; $i < count($rooms); $i++) {
                $room_adults_count = $rooms[$i]["adults"];
                $room_children_count = $rooms[$i]["children"];
                $xml_bdyreqinnerele = $xml->createElement("hot:RoomGuest");
                if ($room_adults_count > 0) {
                    $xml_bdyreqinnerele->setAttribute("AdultCount", $room_adults_count);
                }
                $xml_bdyreqinnerele->setAttribute("ChildCount", $room_children_count);

                if ($room_children_count > 0) {
                    for ($x = 0; $x < count($rooms[$i]["children_ages"]); $x++) {
                        $xml_bdyreqinnerele2 = $xml->createElement("hot:ChildAge");
                        $xml_bdyreqinnerele3 = $xml->createElement("hot:int", $rooms[$i]["children_ages"][$x]);
                        $xml_bdyreqinnerele2->appendChild($xml_bdyreqinnerele3);
                        $xml_bdyreqinnerele->appendChild($xml_bdyreqinnerele2);
                    }
                }
                $xml_bdyreqele->appendChild($xml_bdyreqinnerele);
            }
        }

        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:PreferredCurrencyCode", 'USD');
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:ResultCount", $params['resultLimit']);
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:ResponseTime", $this->search_response_timeout);
        $xml_bdyreq->appendChild($xml_bdyreqele);

        $xml_bdyreqele = $xml->createElement("hot:Filters");
        // $hotel_codes_string = "1376565,1345318,1345320,1200255,1128760,1250333,1078234,1347149,1358855,1345321,1108025,1356271,1267547"; //TEST CASE
        // $hotel_codes_string = "1444601"; //TEST CASE
        $hotel_codes_string = implode(',', $params['hotelCodes']);
        $xml_bdyreqinnerele2 = $xml->createElement("hot:HotelCodeList", $hotel_codes_string);
        $xml_bdyreqele->appendChild($xml_bdyreqinnerele2);

        $xml_bdyreqinnerele = $xml->createElement("hot:StarRating", "All");
        $xml_bdyreq->appendChild($xml_bdyreqinnerele);

        $xml_bdyreqinnerele = $xml->createElement("hot:OrderBy", "PriceDesc");
        $xml_bdyreq->appendChild($xml_bdyreqinnerele);

        $xml_bdy->appendChild($xml_bdyreq);
        $xml_env->appendChild($xml_bdy);

        $xml->appendChild($xml_env);
        $soap_request = $xml->saveXML();

        // // Embed username and password into the SOAP request
        // $soap_request = str_replace(
        //     '<hot:Credentials UserName="' . $this->username . '" Password="' . $this->password . '"/>',
        //     '',
        //     $soap_request
        // );

        // Return the URL and XML data as an associative array
        $WSDL = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";
        $user = $this->username;
        $password = $this->password;
        $requestConfig = [
            'url' => $WSDL,
            'headers' => [
                'Content-Type' => 'application/soap+xml; charset=utf-8',
                'SOAPAction' => 'http://TekTravel/HotelBookingApi/HotelSearch',
                'Accept' => 'text/xml',
                'Cache-Control' => 'no-cache',
                'Pragma' => 'no-cache',
            ],
            'auth' => [
                'username' => $user,
                'password' => $password,
            ],
            'data' => $soap_request
        ];

        return $requestConfig;
    }


    //================================================== Available Rooms ================================================
    public function availableRooms($params)
    {
        // return $params;
        $soap_request = '<soapenv:Envelope xmlns:soapenv="http://www.w3.org/2003/05/soap-envelope" xmlns:hot="http://TekTravel/HotelBookingApi">
		<soapenv:Header xmlns:wsa="http://www.w3.org/2005/08/addressing" >
		<hot:Credentials UserName="' . $this->username . '" Password="' . $this->password . '">
			</hot:Credentials>
			<wsa:Action>http://TekTravel/HotelBookingApi/AvailableHotelRooms</wsa:Action>
			<wsa:To>https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc</wsa:To>
		</soapenv:Header>
		<soapenv:Body>
		<hot:HotelRoomAvailabilityRequest>
		<hot:SessionId>' . $params['sessionId'] . '</hot:SessionId>
        <hot:ResultIndex>' . $params['resultIndex'] . '</hot:ResultIndex>
		<hot:HotelCode>' . $params['hotelCode'] . '</hot:HotelCode>
		<hot:ResponseTime>5</hot:ResponseTime>
		<hot:IsCancellationPolicyRequired>true</hot:IsCancellationPolicyRequired>
		</hot:HotelRoomAvailabilityRequest>
		</soapenv:Body>
		</soapenv:Envelope>';

        $file_name = 'available_rooms_request.xml';
        //save_to_file($file_name, 'hotels', 'tbo', $soap_request);

        $WSDL = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";
        $user = $this->username;
        $password = $this->password;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER,         false);
        curl_setopt($ch, CURLOPT_URL,            $WSDL);
        curl_setopt($ch, CURLOPT_FAILONERROR,    true);
        curl_setopt($ch, CURLOPT_HTTPHEADER,     array(
            'Content-Type: application/soap+xml; charset=utf-8',
            'SOAPAction: "run"',
            'Accept: text/xml',
            'Cache-Control: no-cache',
            'Pragma: no-cache',
            'Content-length: ' . strlen($soap_request),
            'User-Agent: PHP-SOAP/7.0.10',
            'Accept-Encoding', 'gzip, deflate'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_USERPWD,        $user . ":" . $password);
        //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        //curl_setopt($ch, CURLOPT_TIMEOUT,        30);
        curl_setopt($ch, CURLOPT_POSTFIELDS,     $soap_request);
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        $verbose = fopen('php://temp', 'w+');
        curl_setopt($ch, CURLOPT_STDERR, $verbose);
        $response = curl_exec($ch);
        //echo curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($response === FALSE) {
            printf(
                "cUrl error (#%d): %s<br>\n",
                curl_errno($ch),
                htmlspecialchars(curl_error($ch))
            );
        }

        rewind($verbose);
        curl_close($ch);
        return $response;
    }
    //================================================= Pricing =======================================================
    public function availablityPricing($session_id = "", $hotel_result_index, $fixed_format, $combination)
    {
        $soap_request = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:hot="http://TekTravel/HotelBookingApi">
		<soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing" >
		<hot:Credentials UserName="' . $this->username . '" Password="' . $this->password . '">
		</hot:Credentials>
		<wsa:Action>http://TekTravel/HotelBookingApi/AvailabilityAndPricing</wsa:Action>
		<wsa:To>https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc</wsa:To>
		</soap:Header>
		<soap:Body>
		<hot:AvailabilityAndPricingRequest>
		<hot:ResultIndex>' . $hotel_result_index . '</hot:ResultIndex>';

        if (!empty($session_id)) {
            $soap_request .= '<hot:SessionId>' . $session_id . '</hot:SessionId>';
        }

        $soap_request .= '<hot:OptionsForBooking>';
        if ($fixed_format != "") {
            $soap_request .= '<hot:FixedFormat>' . $fixed_format . '</hot:FixedFormat>';
        } else {
            $soap_request .= '<hot:FixedFormat>true</hot:FixedFormat>';
        }
        $soap_request .= '<hot:RoomCombination>';
        foreach ($combination as $rindex) {
            $soap_request .= '<hot:RoomIndex>' . $rindex . '</hot:RoomIndex>';
        }
        $soap_request .= '</hot:RoomCombination>
		
		</hot:OptionsForBooking>
		<hot:IsRoomInformationRequired>true</hot:IsRoomInformationRequired>
		</hot:AvailabilityAndPricingRequest>
		</soap:Body>
		</soap:Envelope>';
        //$myfile = fopen("availability_and_pricing_request.xml", "w");
        //fwrite($myfile, $soap_request);
        //fclose($myfile);

        $WSDL = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";
        $user = $this->username;
        $password = $this->password;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER,         false);
        curl_setopt($ch, CURLOPT_URL,            $WSDL);
        curl_setopt($ch, CURLOPT_FAILONERROR,    true);
        curl_setopt($ch, CURLOPT_HTTPHEADER,     array(
            'Content-Type: application/soap+xml; charset=utf-8',
            'SOAPAction: "run"',
            'Accept: text/xml',
            'Cache-Control: no-cache',
            'Pragma: no-cache',
            'Content-length: ' . strlen($soap_request),
            'User-Agent: PHP-SOAP/7.0.10',
            'Accept-Encoding', 'gzip, deflate'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_USERPWD,        $user . ":" . $password);
        //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        //curl_setopt($ch, CURLOPT_TIMEOUT,        30);
        curl_setopt($ch, CURLOPT_POSTFIELDS,     $soap_request);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }
    //================================================= booking ======================================================
    public function book($params)
    {
        $soap_request = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:hot="http://TekTravel/HotelBookingApi">
		<soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing" >
		<hot:Credentials UserName="' . $this->username . '" Password="' . $this->password . '">
		</hot:Credentials>
		<wsa:Action>http://TekTravel/HotelBookingApi/HotelBook</wsa:Action>
		<wsa:To>https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc</wsa:To>
		</soap:Header>
		<soap:Body>
		<hot:HotelBookRequest>
		<hot:ClientReferenceNumber>' . $params['client_reference_number'] . '</hot:ClientReferenceNumber>
		<hot:GuestNationality>' . $params['nationality'] . '</hot:GuestNationality>
		<hot:Guests>';
        $lead = "false";
        $rooms_guests = $params['rooms_guests'];
        for ($i = 0; $i < count($params['rooms_guests']); $i++) {
            $x = $i + 1;
            $room_adults_count = count($rooms_guests[$i]['adults']);
            for ($y = 0; $y < $room_adults_count; $y++) {
                if ($i == 0 && $y == 0) {
                    $lead = "true";
                } else {
                    $lead = "false";
                }
                $soap_request .= '<hot:Guest LeadGuest="' . $lead . '" GuestType="Adult" GuestInRoom="' . $x . '">
				<hot:Title>' . $rooms_guests[$i]['adults'][$y]['title'] . '</hot:Title>
				<hot:FirstName>' . $rooms_guests[$i]['adults'][$y]['first_name'] . '</hot:FirstName>
				<hot:LastName>' . $rooms_guests[$i]['adults'][$y]['last_name'] . '</hot:LastName>
				</hot:Guest>';
            }

            $room_children_count = count($rooms_guests[$i]['children']);
            for ($z = 0; $z < $room_children_count; $z++) {
                $soap_request .= '<hot:Guest LeadGuest="false" GuestType="Child" GuestInRoom="' . $x . '">
				<hot:Title>' . $rooms_guests[$i]['children'][$z]['title'] . '</hot:Title>
				<hot:FirstName>' . $rooms_guests[$i]['children'][$z]['first_name'] . '</hot:FirstName>
				<hot:LastName>' . $rooms_guests[$i]['children'][$z]['last_name'] . '</hot:LastName>
				<hot:Age>' . $rooms_guests[$i]['children'][$z]['age'] . '</hot:Age>
				</hot:Guest>';
            }
        }

        $soap_request .= '</hot:Guests>';

        $soap_request .= '<hot:PaymentInfo VoucherBooking="true" PaymentModeType="Limit">
		</hot:PaymentInfo>
		<hot:SessionId>' . $params['session_id'] . '</hot:SessionId>
		<hot:NoOfRooms>' . count($rooms_guests) . '</hot:NoOfRooms>
		<hot:ResultIndex>' . $params['hotel_result_index'] . '</hot:ResultIndex>
		<hot:HotelCode>' . $params['hotel_code'] . '</hot:HotelCode>
		<hot:HotelName>' . $params['hotel_name_en'] . '</hot:HotelName>
		<hot:HotelRooms>';
        //print_r($selected_rooms);die;
        $selected_rooms = json_decode(json_encode($params['selected_rooms']), true);
        if (!is_array($selected_rooms)) {
            throw new Exception("Selected rooms is empty from supplier " . json_encode($selected_rooms));
        }
        foreach ($selected_rooms as $room) {
            $soap_request .= '<hot:HotelRoom>
			<hot:RoomIndex>' . $room['RoomIndex'] . '</hot:RoomIndex>
			<hot:RoomTypeName>' . $room['RoomTypeName'] . '</hot:RoomTypeName><hot:RoomTypeCode>' . $room['RoomTypeCode'] . '</hot:RoomTypeCode>
			<hot:RatePlanCode>' . $room['RatePlanCode'] . '</hot:RatePlanCode>
			<hot:RoomRate RoomFare="' . $room['RoomRate']['@attributes']['RoomFare'] . '" Currency="' . $room['RoomRate']['@attributes']['Currency'] . '" AgentMarkUp="' . $room['RoomRate']['@attributes']['AgentMarkUp'] . '" RoomTax="' . $room['RoomRate']['@attributes']['RoomTax'] . '" TotalFare="' . $room['RoomRate']['@attributes']['TotalFare'] . '"/>';
            if (isset($room['Supplements']) && count($room['Supplements'])) {
                $soap_request .= '<hot:Supplements>';
                foreach ($room['Supplements'] as $supp) {
                    if ($supp['@attributes']['SuppChargeType'] == "AtProperty" && $supp['@attributes']['SuppIsMandatory'] == true) {
                        $soap_request .= '<hot:SuppInfo SuppID="' . $supp['@attributes']['SuppID'] . '" SuppChargeType="' . $supp['@attributes']['SuppChargeType'] . '" Price="' . $supp['@attributes']['Price'] . '" SuppIsSelected="true"/>';
                    }
                }
                $soap_request .= '</hot:Supplements>';
            }
            $soap_request .= '</hot:HotelRoom>';
        }
        $soap_request .= '</hot:HotelRooms>
		</hot:HotelBookRequest>
		</soap:Body>
		</soap:Envelope>';
        //$myfile = fopen("hotel_book_request.xml", "w");
        //fwrite($myfile, $soap_request);
        //fclose($myfile);
        //echo "<pre>";echo $session_id;echo "<br><br>";echo $soap_request;die;
        $WSDL = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";
        $user = $this->username;
        $password = $this->password;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER,         false);
        curl_setopt($ch, CURLOPT_URL,            $WSDL);
        curl_setopt($ch, CURLOPT_FAILONERROR,    true);
        curl_setopt($ch, CURLOPT_HTTPHEADER,     array(
            'Content-Type: application/soap+xml; charset=utf-8',
            'SOAPAction: "run"',
            'Accept: text/xml',
            'Cache-Control: no-cache',
            'Pragma: no-cache',
            'Content-length: ' . strlen($soap_request),
            'User-Agent: PHP-SOAP/7.0.10',
            'Accept-Encoding', 'gzip, deflate'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_USERPWD,        $user . ":" . $password);
        //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        //curl_setopt($ch, CURLOPT_TIMEOUT,        30);
        curl_setopt($ch, CURLOPT_POSTFIELDS,     $soap_request);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    //================================================== Invoice Voucher ===============================
    public function generate_invoice($confirmation_number)
    {
        $soap_request = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:hot="http://TekTravel/HotelBookingApi">
		<soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing" >
		<hot:Credentials UserName="' . $this->username . '" Password="' . $this->password . '"> </hot:Credentials>
		<wsa:Action>http://TekTravel/HotelBookingApi/GenerateInvoice</wsa:Action>
		<wsa:To>https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc</wsa:To>
		</soap:Header>
		<soap:Body>
		<hot:GenerateInvoiceRequest>
		<hot:ConfirmationNo>' . $confirmation_number . '</hot:ConfirmationNo>
		<hot:PaymentInfo VoucherBooking="true" PaymentModeType="Limit">
		</hot:PaymentInfo>
		</hot:GenerateInvoiceRequest>
		</soap:Body>
		</soap:Envelope>';
        //var_dump($soap_request);
        //die;

        //$myfile = fopen("generate_invoice_request.xml", "w");
        //fwrite($myfile, $soap_request);
        //fclose($myfile);

        $WSDL = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";
        $user = $this->username;
        $password = $this->password;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER,         false);
        curl_setopt($ch, CURLOPT_URL,            $WSDL);
        curl_setopt($ch, CURLOPT_FAILONERROR,    true);
        curl_setopt($ch, CURLOPT_HTTPHEADER,     array(
            'Content-Type: application/soap+xml; charset=utf-8',
            'SOAPAction: "run"',
            'Accept: text/xml',
            'Cache-Control: no-cache',
            'Pragma: no-cache',
            'Content-length: ' . strlen($soap_request),
            'User-Agent: PHP-SOAP/7.0.10',
            'Accept-Encoding', 'gzip, deflate'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_USERPWD,        $user . ":" . $password);
        //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        //curl_setopt($ch, CURLOPT_TIMEOUT,        30);
        curl_setopt($ch, CURLOPT_POSTFIELDS,     $soap_request);

        $response = curl_exec($ch);
        //print($response);die;
        if (empty($response)) {
            //throw new SoapFault('CURL error: '.curl_error($ch), curl_errno($ch)); 
            print(curl_error($ch));
            die;
        }
        curl_close($ch);
        //var_dump($response);
        //die;
        return $response;
    }
    //================================================== Booking Details ===============================
    public function bookingDetails($confNum)
    {
        $soap_request = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:hot="http://TekTravel/HotelBookingApi">
		<soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing" >
		<hot:Credentials UserName="' . $this->username . '" Password="' . $this->password . '"> </hot:Credentials>
		<wsa:Action>http://TekTravel/HotelBookingApi/HotelBookingDetail</wsa:Action>
		<wsa:To>https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc</wsa:To>
		</soap:Header>
		<soap:Body>
		<hot:HotelBookingDetailRequest>
		<hot:ClientReferenceNumber>' . $confNum . '</hot:ClientReferenceNumber>
		</hot:HotelBookingDetailRequest>
		</soap:Body>
		</soap:Envelope>';
        //var_dump($soap_request);
        //die;
        $file_name = "booking_details_request.xml";
        //save_to_file($file_name, 'hotels', 'tbo', $soap_request);
        $WSDL = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";
        $user = $this->username;
        $password = $this->password;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER,         false);
        curl_setopt($ch, CURLOPT_URL,            $WSDL);
        curl_setopt($ch, CURLOPT_FAILONERROR,    true);
        curl_setopt($ch, CURLOPT_HTTPHEADER,     array(
            'Content-Type: application/soap+xml; charset=utf-8',
            'SOAPAction: "run"',
            'Accept: text/xml',
            'Cache-Control: no-cache',
            'Pragma: no-cache',
            'Content-length: ' . strlen($soap_request),
            'User-Agent: PHP-SOAP/7.0.10',
            'Accept-Encoding', 'gzip, deflate'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_USERPWD,        $user . ":" . $password);
        //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        //curl_setopt($ch, CURLOPT_TIMEOUT,        30);
        curl_setopt($ch, CURLOPT_POSTFIELDS,     $soap_request);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }
}
