import { reactive, ref, watch } from 'vue'
import {sortBy} from '@/utils/sortObject'
import {Pagination} from '@/utils/pagination'


export const orderBy = ref('lowestPrice')
export const filter = ref({
    hotelName: '',
    unitType: {},
    serviceLevel: {},
    reviews: {},
    paymentTerms: {},
    hotelServices: {}
})

export const filterByBudget = reactive({
    value: [100, 3000],
    max: 3000,
    min: 0,
    format: function (value) {
        return `${value.toFixed(0)}`
    },
    tooltips: false
})

export const rateTransform = (v) => {
    // console.log('rateTransform', v)
   const stars = {
        OneStar: 1,
        TwoStar: 2,
        ThreeStar: 3,
        FourStar: 4,
        FiveStar: 5,
    }
    return stars[v] || 0
}

export const reviewsTransform = (val) => {
    switch(val) {
        case 'excellent': return (v) => v >= 4.5;
        case 'veryGood': return (v) =>  v >= 3.5 && v < 4.5;
        case 'good': return (v) => v >= 3 && v < 3.5;
        default: return (v) => v >= 0 && v < 3;
    }
}

export const orderByKey = (key) => {
    switch(key){
        case 'serviceLevel': return sortBy(rateTransform)('Rating', 'desc')
        case 'bestRated': return sortBy(parseFloat)('TripAdvisorRating', 'desc')
        default: return sortBy(parseFloat)('Price', 'asc')
    }
}

export const sliderKey = ref(0);

export const filterMethod_live = (liveHotels, emit) => {
    // console.log(filterByBudget.value)
    const filterServicelevel = Object.keys(Object.fromEntries(
        Object.entries(filter.value.serviceLevel).filter(([key, value]) => value )
    ))
    
    const filterReviews = Object.keys(Object.fromEntries(
        Object.entries(filter.value.reviews).filter(([key, value]) => value )
    ))

    const sorted = liveHotels.value.sort(orderByKey(orderBy.value))

    const filtered = sorted.filter(hotel => {
        // console.log(hotel)
        let valid  = true

        if (filter.value.hotelName && !hotel.Name.toLowerCase().includes(filter.value.hotelName.toLowerCase())) {
            valid = false;
        }
        
        if(filterServicelevel.length && !filterServicelevel.includes(rateTransform(hotel.Rating) +'')){
            valid = false
        }

        let reviewsState = false
        if(filterReviews.length) {
            filterReviews.forEach(item => {
                if(reviewsTransform(item)(parseFloat(hotel.TripAdvisorRating))) {
                    reviewsState = true
                }
            });
            if(!reviewsState){
                valid = false
            }
        }

        const price = +hotel.Price
        if(price < filterByBudget.value[0] || price > filterByBudget.value[1]){
            valid = false
        }
        return valid
    })

    let pagination = new Pagination(filtered)
    emit('update:live', {
        data: pagination.first(),
        pagination: pagination
    })
}
    
export const filterMethod_static = (staticHotels, emit) => {
    const filterServicelevel = Object.keys(Object.fromEntries(
        Object.entries(filter.value.serviceLevel).filter(([key, value]) => value )
    ))

    const filterReviews = Object.keys(Object.fromEntries(
        Object.entries(filter.value.reviews).filter(([key, value]) => value )
    ))

    const sorted = Object.values(staticHotels.value).sort(orderByKey(orderBy.value))

    const filtered = sorted.filter(hotel => {
        // console.log(hotel)
        let valid  = true
        if(filterServicelevel.length && !filterServicelevel.includes(rateTransform(hotel.Rating) +'')){
            valid = false
        }

        let reviewsState = false
        if(filterReviews.length) {
            filterReviews.forEach(item => {
                if(reviewsTransform(item)(parseFloat(hotel.TripAdvisorRating))) {
                    reviewsState = true
                }
            });
            if(!reviewsState){
                valid = false
            }
        }

        // console.log(filterReviews, reviewsTransform(hotel.TripAdvisorRating))
        return valid
    })
    emit('update:static', filtered)
}