import flightApi from '@/modules/flights/Flights_API'
import cache from '@/utils/cache'
import axios from 'axios'
const api = axios;
export const getAirportsFromCache = () => {
    return cache.get('Terminal.AirportList') || {}
}

export const getAirlinesFromCache = () => {
    return cache.get('Terminal.AirlineList') || {}
}

export const getAirplanesFromCache = () => {
    return cache.get('Terminal.CraftList') || {}
}

export const getAirportsByCodes = (codes) => {
    let cachedAirports = getAirportsFromCache()
    let neededCodes = codes.filter(v => {
        return !cachedAirports[v]
    })
    if(!neededCodes.length){
        return cachedAirports
    }
    let airportList = {}
    return api.post(flightApi.airports(), {airports: codes}).then(res => {
        if(res.data.status){
            res.data.data.forEach(item => {
                if(item.Name != '' && item.Name != '\\N'){
                    airportList[item.Code.toUpperCase()] = item
                }
            })
        }
        // console.log('airportList', airportList)
        cache.forever('Terminal.AirportList', airportList)
        return airportList
    }).catch(err => {
        console.error(err)
    })
}

export const getAirlinesByCodes = (codes) => {
    let cachedAirlines = getAirlinesFromCache()
    let neededCodes = codes.filter(v => {
        return !cachedAirlines[v]
    })
    if(!neededCodes.length){
        return cachedAirlines
    }
    let airlineList = {}
    return api.post(flightApi.airlines(), {airlines: codes}).then(res => {
        if(res.data.status){
            res.data.data.forEach(item => {
                if(item.Name != '' && item.Name != '\\N'){
                    airlineList[item.Code.toUpperCase()] = item
                }
            })
        }
        // console.log('airlineList', airlineList)
        cache.forever('Terminal.AirlineList', airlineList)
        return airlineList

    }).catch(err => {
        console.error(err)
    })
}

export const getAirplanesByCodes = (codes) => {
    let cachedAirplanes = getAirplanesFromCache()
    let neededCodes = codes.filter(v => {
        return !cachedAirplanes[v]
    })
    if(!neededCodes.length){
        return cachedAirplanes
    }
    let airplaneList = {}
    return api.post(flightApi.airplanes(), {airplanes: codes}).then(res => {
        if(res.data.status){
            res.data.data.forEach(item => {
                if(item.Name != '' && item.Name != '\\N'){
                    if(item.iata !== '\\N'){
                        airplaneList[item.iata.toUpperCase()] = item
                    }
                    if(item.icao !== '\\N'){
                        airplaneList[item.icao.toUpperCase()] = item
                    }
                }
            })
        }
        console.log('airplaneList', airplaneList)
        cache.forever('Terminal.CraftList', airplaneList)
        return airplaneList

    }).catch(err => {
        console.error(err)
    })
}
