import { createRouter, createWebHistory } from "vue-router";
import { supportedLocales, defaultLocale, setLocale } from "@/plugins/i18n";
import { getCurrentPageMenu } from "@/utils/menu";
import store from '@/state'

const langParam = supportedLocales.join('|')
const routes = [
    { name: 'home', path: `/:lang(${langParam})?/`, component: () => import('@/pages/Home.vue') },
    { name: 'search', path: `/:lang(${langParam})?/search/:type?`, component: () => import('@/pages/Search.vue') },
    //======================================================================
    { name: 'hotels', path: `/:lang(${langParam})?/hotels`, component: () => import('@/pages/hotels/BookingList.vue') },
    { name: 'hotels-search', path: `/:lang(${langParam})?/hotels/search`, component: () => import('@/pages/hotels/Search.vue') },
    { name: 'hotels-details', path: `/:lang(${langParam})?/hotels/details`, component: () => import('@/pages/hotels/Details.vue') },
    { name: 'hotel-book', path: `/:lang(${langParam})?/hotels/book`, component: () => import('@/pages/hotels/Book.vue') },
    { name: 'hotels-pay', path: `/:lang(${langParam})?/hotels/pay/:bookId/:sessionId`, component: () => import('@/pages/hotels/Pay.vue') },
    { name: 'hotels-booking-confirmation', path: `/:lang(${langParam})?/hotels/booking-confirmation/:bookId`, component: () => import('@/pages/hotels/BookingConfirmation.vue') },
    { name: 'hotels-booking-list', path: `/:lang(${langParam})?/hotels/booking-list/:page?`, component: () => import('@/pages/hotels/BookingList.vue') },
    //======================================================================
    { name: 'flights', path: `/:lang(${langParam})?/flights`, component: () => import('@/pages/flights/BookingList.vue') },
    { name: 'flights-search', path: `/:lang(${langParam})?/flights/search`, component: () => import('@/pages/flights/Search.vue') },
    { name: 'flights-book', path: `/:lang(${langParam})?/flights/book/:sessionId`, component: () => import('@/pages/flights/Book.vue') },
    { name: 'flights-pay', path: `/:lang(${langParam})?/flights/pay/:bookId/:sessionId`, component: () => import('@/pages/flights/Pay.vue') },
    { name: 'flights-booking-confirmation', path: `/:lang(${langParam})?/flights/booking-confirmation/:bookId`, component: () => import('@/pages/flights/BookingConfirmation.vue') },
    { name: 'flights-booking-list', path: `/:lang(${langParam})?/flights/booking-list/:page?`, component: () => import('@/pages/flights/BookingList.vue') },
    //=======================================================================
    { name: 'locales', path: `/:lang(${langParam})?/locales`, component: () => import('@/pages/locales/Currencies.vue') },
    { name: 'locales-currencies', path: `/:lang(${langParam})?/locales`, component: () => import('@/pages/locales/Currencies.vue') },
    //======================================================================
    { name: 'packages', path: `/:lang(${langParam})?/packages`, component: () => import('@/pages/flights/BookingList.vue') },
    //======================================================================
    { name: 'activites', path: `/:lang(${langParam})?/activites`, component: () => import('@/pages/flights/BookingList.vue') },
    //======================================================================
    { name: 'transfers', path: `/:lang(${langParam})?/transfers`, component: () => import('@/pages/flights/BookingList.vue') },
    //======================================================================
    { name: 'payments', path: `/:lang(${langParam})?/payments/:page?`, component: () => import('@/pages/payments/Index.vue') },
    //=======================================================================
    //======================================================================
    // { name: 'Loggers', path: `/:lang(${langParam})?/Loggers/:page?`, component: () => import('@/pages/common/loggers/Index.vue') },
    //=======================================================================
    // { name: 'content', path: `/:lang(${langParam})?/content`, component: () => import('@/pages/content/Index.vue'), meta: { userType: 'b2c' } },
    // { name: 'content-pages', path: `/:lang(${langParam})?/content/pages`, component: () => import('@/pages/content/Pages.vue'), meta: { userType: 'b2c' } },
    // { name: 'content-sections', path: `/:lang(${langParam})?/content/sections`, component: () => import('@/pages/content/Sections.vue'), meta: { userType: 'b2c' } },
    // { name: 'content-pages-sections', path: `/:lang(${langParam})?/content/pages/sections`, component: () => import('@/pages/content/Pages_sections.vue'), meta: { userType: 'b2c' } },
    // { name: 'content-links', path: `/:lang(${langParam})?/content/links`, component: () => import('@/pages/content/Links.vue'), meta: { userType: 'b2c' } },
    // { name: 'content-faq', path: `/:lang(${langParam})?/content/faq`, component: () => import('@/pages/content/Faq.vue'), meta: { userType: 'b2c' } },
    // { name: 'content-users-questions', path: `/:lang(${langParam})?/content/users-questions`, component: () => import('@/pages/content/User_questions.vue'), meta: { userType: 'b2c' } },
    //=======================================================================
    { name: 'settings', path: `/:lang(${langParam})?/settings`, component: () => import('@/pages/settings/App_Settings.vue') },
    { name: 'settings-app', path: `/:lang(${langParam})?/settings/app`, component: () => import('@/pages/settings/App_Settings.vue') },
    { name: 'settings-supplier', path: `/:lang(${langParam})?/settings/supplier`, component: () => import('@/pages/settings/Supplier_Settings.vue') },
    { name: 'settings-public', path: `/:lang(${langParam})?/settings/public/:userId?`, component: () => import('@/pages/settings/Public_Settings.vue') },
    //=======================================================================
    { name: 'users', path: `/:lang(${langParam})?/users`, component: () => import('@/pages/users/Users.vue'), meta: { type: 'employee', name: 'employees' } },
    { name: 'users-companies', path: `/:lang(${langParam})?/companies`, component: () => import('@/pages/users/Users.vue'), meta: { type: 'company', name: 'companies' } },
    { name: 'users-company-employees', path: `/:lang(${langParam})?/company-employees/:companyId`, component: () => import('@/pages/users/Users.vue'), meta: { type: 'company_employees', name: 'company_employees' } },
    { name: 'users-groups', path: `/:lang(${langParam})?/users/groups`, component: () => import('@/pages/users/Groups.vue') },
    { name: 'user_settings', path: `/:lang(${langParam})?/user_settings/:userId?`, component: () => import('@/modules/users/components/Settings.vue') },
    //========================================================================
    { name: 'markups', path: `/:lang(${langParam})?/markups`, component: () => import('@/pages/markups/Markup.vue') },
    //========================================================================
    { name: 'logs', path: `/:lang(${langParam})?/logs`, component: () => import('@/pages/logs/Logs.vue') },
    { name: 'logs-users-online', path: `/:lang(${langParam})?/logs/users/online`, component: () => import('@/pages/logs/LogsUsersOnline.vue') },
    { name: 'logs-users-tracking', path: `/:lang(${langParam})?/logs/users/tracking/:id?`, component: () => import('@/pages/logs/LogsUsersTracking.vue') },
    //=======================================================================   
    { name: 'notifications', path: `/:lang(${langParam})?/notifications`, component: () => import('@/pages/notifications/Notifications.vue') },
    //=======================================================================   
    { name: 'reports', path: `/:lang(${langParam})?/reports`, component: () => import('@/pages/reports/SuppliersReports.vue') },
    { name: 'reports-suppliers', path: `/:lang(${langParam})?/reports/suppliers`, component: () => import('@/pages/reports/SuppliersReports.vue') },
    { name: 'reports-clients', path: `/:lang(${langParam})?/reports/clients`, component: () => import('@/pages/reports/ClientsReports.vue') },
    { name: 'reports-confirmed-orders', path: `/:lang(${langParam})?/reports/confirmed-orders`, component: () => import('@/pages/reports/ConfirmedOrdersReports.vue') },
    { name: 'reports-canceled-orders', path: `/:lang(${langParam})?/reports/canceled-orders`, component: () => import('@/pages/reports/CanceledOrdersReports.vue') },
    { name: 'reports-payments', path: `/:lang(${langParam})?/reports/payments`, component: () => import('@/pages/reports/PaymentsReports.vue') },
    //=======================================================================    //=======================================================================
    { name: 'profile', path: `/:lang(${langParam})?/profile`, component: () => import('@/pages/auth/Profile.vue') },
    { name: 'user-settings', path: `/:lang(${langParam})?/profile/settings`, component: () => import('@/pages/auth/Settings.vue') },
    { name: 'login', path: `/:lang(${langParam})?/login`, component: () => import('@/pages/auth/Login.vue') },
    { name: 'forbidden', path: '/forbidden', component: () => import('@/pages/Forbidden.vue') },
    { path: '/:404(.*)*', component: () => import('@/pages/NotFound.vue') }
]

export const router = createRouter({
    // history: createWebHistory('/subfolder/'),
    history: createWebHistory(),
    routes,
});
//============================================
//==== permission middleware
router.beforeEach(async (to, from) => {
    if (['login', 'forbidden'].includes(to.name)) {
        return
    }

    store.setPageLoad(true)
    let value = await new Promise((resolve, reject) => {
        const waitUser = setInterval(() => {
            if (store.state.user && store.state.user.info && store.state.user.info.type) {
                clearInterval(waitUser)
                resolve(true)
                // console.log(state.state.user.info)
            }
        }, 100)
    }).then(() => {
        if (to.meta.userType && !store.isUserType(to.meta.userType)) {
            return {
                name: 'forbidden',
            }
        } else {
            return true
        }
    })
    // console.log('value', value)
    store.setPageLoad(false)
    return value
});
//==================================================

router.beforeEach((to, from, next) => {
    let { lang } = to.params
    if (lang && supportedLocales.includes(lang) && lang != defaultLocale()) {
        setLocale(lang)
    }
    if (to.name) {
        let module = to.name.split('-')[0]
        store.setPage({
            menu: getCurrentPageMenu(module)
        })
    }

    next()
});

router.afterEach(() => {
    document.body.scrollTop = 0; // For Safari
    document.documentElement.scrollTop = 0;
    store.setPageLoad(false)
})
