<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id');
                $table->string('type');
                $table->tinyInteger('read')->default(0);
                $table->tinyInteger('email_sent')->default(0);
                $table->timestamp('email_sent_at');
                $table->string('message');
                $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notification');
    }
}
