<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFlightsBookingListTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights_booking_list', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('company_id');
            $table->string('wow_merchant_ref', 20)->unique();
            $table->string('supplier_name', 50)->nullable();
            $table->integer('adult_count');
            $table->integer('child_count');
            $table->integer('infant_count');
            $table->string('user_data', 100)->nullable();
            $table->string('mobile', 255)->nullable();
            $table->string('email', 50)->nullable();
            $table->string('wow_session', 200)->nullable();
            $table->string('supplier_session', 200)->nullable();
            $table->string('uuid', 200)->nullable();
            $table->string('booking_status', 50)->nullable(); //->default('1')
            $table->string('ticket_status', 50)->nullable();
            $table->string('pnr', 100)->nullable();
            $table->string('ip_address', 100)->nullable();
            $table->string('country_code', 10)->nullable();
            $table->decimal('amount', 18, 3)->default(0.000);
            // $table->float('original_amount')->default(0);
            $table->string('currency_code', 20)->nullable();
            $table->string('payment_status', 20)->nullable();
            $table->integer('payment_deadline')->nullable();
            $table->integer('is_lcc');
            $table->integer('is_reissue_allowed');
            $table->integer('is_refund_allowed');
            $table->integer('is_online_refund_allowed');
            $table->integer('is_void_allowed');
            $table->integer('is_deleted')->default(0);
            $table->text('booking_details')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flights_booking_list');
    }
}
