<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHotelsBookingListTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotels_booking_list', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('company_id');
            $table->string('wow_merchant_ref', 20)->unique();
            $table->string('supplier_name', 50)->nullable();
            $table->integer('payment_status')->nullable();
            $table->integer('payment_deadline')->nullable();
            $table->integer('is_deleted')->default(0);
            $table->string('supplier_booking_id', 100)->nullable();
            $table->string('supplier_ref_number', 100)->nullable();
            $table->string('amendment_status', 50)->nullable();
            $table->string('booking_status', 50)->nullable(); //->default('1')
            $table->string('voucher_status', 50)->nullable();
            $table->string('confirmation_number', 100)->nullable();
            $table->string('invoice_number', 100)->nullable();
            $table->integer('hotel_id')->nullable();
            $table->string('trip_name', 100)->nullable();
            $table->string('hotel_name', 200)->nullable();
            $table->string('hotel_rating', 100)->nullable();
            $table->string('city_code', 100)->nullable();
            $table->string('city_name', 200)->nullable();
            $table->string('from_date', 100)->nullable();
            $table->string('to_date', 100)->nullable();
            $table->string('last_cancellation_deadline', 100)->nullable();
            $table->string('current_cancellation_charge', 100)->nullable();
            $table->string('rooms_number', 100)->nullable();
            $table->string('rooms_type_name', 100)->nullable();
            $table->string('currency_code', 100)->nullable();
            $table->decimal('amount', 18, 3)->default(0.000);
            // $table->float('original_amount')->nullable;
            $table->string('booking_date', 100)->nullable();
            // $table->text('booking_details')->nullable;
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotels_booking_list');
    }
}
