<?php

namespace Modules\Users\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Modules\Users\Entities\Permission;
use Modules\Users\Entities\Role;
use Spatie\Permission\PermissionRegistrar;
use Modules\Users\Entities\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Route;
use Modules\Users\Http\Controllers\PermissionsController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run(Request $request)
    {
        //seed admin info into local DB to assign permissions later
        $admin = User::updateOrCreate(['email' => env('ADMIN_EMAIL')], [
            'email' => env('ADMIN_EMAIL'),
            'first_name' => '',
            'last_name' => '',
            'mobile' => '',
            'password' => 'password',
        ]);
        //create operation account under sata
        $sata_operation = User::updateOrCreate(['email' => 'operation@sata.com'], [
            'email' => 'operation@sata.com',
            'first_name' => 'operation',
            'last_name' => 'sata',
            'mobile' => '',
            'type' => 'employee',
            'parent_id' => $admin->id,
            'password' => Hash::make('123'),
        ]);
        //create accountant account under sata
        $sata_accountant = User::updateOrCreate(['email' => 'accountant@sata.com'], [
            'email' => 'accountant@sata.com',
            'first_name' => 'accountant',
            'last_name' => 'sata',
            'mobile' => '',
            'type' => 'employee',
            'parent_id' => $admin->id,
            'password' => Hash::make('123'),
        ]);

        Model::unguard();
        app()[PermissionRegistrar::class]->forgetCachedPermissions();
        //reset old permissions
        $permissions = Permission::where('type', 'local')->get()->all();
        foreach ($permissions as $permission) {
            $permission->delete();
        }

        function get_module_routes($module)
        {
            $actions = [];
            $routes = collect(Route::getRoutes())->map(function ($route) {
                return $route->action;
            });
            // return $routes;
            foreach ($routes as $route) {
                if (isset($route['as']) && Str::startsWith($route['uses'], 'Modules\\' . $module)) {
                    $actions[] = $route['as'];
                }
            }
            return $actions;
        }

        $modules = ['Users', 'Markup', 'Reports', 'Settings', 'Common'];
        foreach ($modules as $module) {
            //create module permissions
            $modulePermissions = get_module_routes($module);
            //seeding modulePermissions in DB
            foreach ($modulePermissions as $permission) {
                Permission::updateOrCreate(['name' => $permission, 'guard_name' => 'sanctum', 'type' => 'local']);
            }
        }

        //create user permissions
        $usersPermissions = get_module_routes('Users');
        $markupPermissions = get_module_routes('Markup');
        //groups
        $accounting = Role::updateOrCreate(['name' => 'accounting', 'user_id' => $admin->id, 'guard_name' => 'sanctum', 'desc' => 'this for accounting']);
        $operations = Role::updateOrCreate(['name' => 'operation', 'user_id' => $admin->id, 'guard_name' => 'sanctum', 'desc' => 'this for operation']);
        //users permissions without update credit
        $usersPermissions = array_diff($usersPermissions, ["users_update_credit_amount"]);
        //assign Users Permissions to Operations Group
        $operations->syncPermissions($usersPermissions);
        //add update credit to accounting permissions group
        //assign users , companies list to accountant permission group
        array_push($markupPermissions, ["users_update_credit_amount", "users_list_companies", "users_list_employees"]);
        //assign Mark Permissions to Accounting Group
        $accounting->syncPermissions($markupPermissions);

        //create admin super_admin to be assigned with all permissions
        $super_admin = Role::updateOrCreate(['name' => 'super_admin', 'user_id' => $admin->id, 'guard_name' => 'sanctum', 'desc' => 'Super Admin got all permissions']);
        $admin->assignRole($super_admin);
        //sync permissions
        $permission_controller = new PermissionsController($request);
        $permission_controller->SyncPermissionsFromBackOffice();

        //assign roles to operation & accountant of sata
        $sata_operation->assignRole($operations);
        $sata_accountant->assignRole($accounting);

    }
}
