<?php

namespace Modules\Common\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Route;
use Modules\Common\Entities\Log;
use Modules\Users\Entities\User;

class LogsController extends Controller
{

    public function addlog($request, $response)
    {

        $methods_to_log = ['POST', 'PATCH', 'PUT', 'DELETE'];
        $route = Route::getCurrentRoute();
        $route_action_controller = explode("@", $route->getActionName());
        $method = $request->getMethod();
        //check methods to log
        if (in_array($method, $methods_to_log)) {
            $action = $route->action['as']; // get action
            $controller = $route_action_controller[0];     // get controller
            $parameters = $request->all();   // get url parameters
            $user = $request->user();
            $parent_id = $request->get('parent');
            $parent = User::where('id', $parent_id)->first();
            Log::create([
                'route' => $route,
                'controller' => $controller,
                'action' => $action,
                'method' => $method,
                'user_id' => $user->id,
                'user_name' => $user->first_name . ' ' . $user->last_name,
                'company_id' => $parent_id,
                'company_name' => $parent->company,
                'parameters' => $parameters,
                'response_status' => $response->status(),
                'response_content' => json_decode($response->getContent()),
            ]);
        }
    }
    public function list(Request $req)
    {
        $logs = Log::
            //when log dates
            when($req->date, function ($query) use ($req) {
                $date = explode('~', $req->date);
                return $query->whereBetween('created_at', [Carbon::parse($date[0])->format('Y-m-d'), Carbon::parse($date[1])->format('Y-m-d')]);
            })
            //when request has method
            ->when($req->method != 'all', function ($query) use ($req) {
                return $query->where('method', $req->method);
            })
            ->orderBy('created_at', 'DESC')->jsonPaginate();
        return json_response_pagination($logs);
    }

    public function users_online(Request $req)
    {
        $users = User::select('users.*', 'users.company as company_name', 'parents.company as parent_company_name')
        ->where('users.last_seen_at', '>', now()->subMinutes(5))
        ->orderBy('users.created_at', 'DESC')
        ->leftJoin('users as parents', 'users.parent_id', '=', 'parents.id')
        ->jsonPaginate();    
        return json_response_pagination($users);
    }

    public function users_tracking(Request $req,$id=null)
    {
        $logs = Log::
            when($req->date, function ($query) use ($req) {
                $date = explode('~', $req->date);
                return $query->whereBetween('created_at', [Carbon::parse($date[0])->format('Y-m-d'), Carbon::parse($date[1])->format('Y-m-d')]);
            })
            // when request has method
            ->when($req->method != 'all', function ($query) use ($req) {
                return $query->where('method', $req->method);
            })
            // when id is not null
            ->when($req->id, function ($query) use ($req) {
                return $query->where('user_id', $req->id);
            })
            ->orderBy('created_at', 'DESC')
            ->jsonPaginate();

        return json_response_pagination($logs);
    }
}
