<?php

namespace Modules\Users\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Users\Entities\User;
use Modules\Users\Entities\Permission;
use Modules\Users\Entities\Role;
use GuzzleHttp\Client;
use GuzzleHttp\Psr7;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\PermissionRegistrar;


class PermissionsController extends Controller
{
    public $client;
    public function __construct(Request $req)
    {
        $headers = [
            'X-Authorization-Token' =>  $req->bearerToken(),
            'X-Access-Token' =>  env('API_TOKEN'),
            'X-Language-Code' => $req->header('X-Language-Code'),
            'X-Country-Code' => $req->header('X-Country-Code'),
            'X-Currency-Code' => $req->header('X-Currency-Code'),
            'X-Client-IP' => $req->ip()
        ];

        if ($req->header('X-Session')) {
            $headers['X-Session'] = $req->header('X-Session');
        }

        $this->client = new Client([
            'base_uri' => env('API_MODULE_BASE'),
            'headers' => $headers
        ]);
    }

    public function permissions(Request $request, $id = 0)
    {
        $parent_id = $id != 0 ? $id : $request->get('parent');
        $user = User::findOrFail($parent_id);
        $actions = [];
        $permissions = [];

        foreach ($user->getAllPermissions() as $row) {
            if (strpos($row['name'], '.') !== false) {
                $permissions[] = $row['name'];
            } else {
                $actions[] = $row['name'];
            }
        }

        return json_response([
            'actions' => $actions,
            'permissions' => $permissions,
        ]);
    }

    public function user_permissions(Request $request, $id)
    {
        $user = User::findOrFail($id);
        $admin = Auth::user();
        $parent_id = $user->parent_id;
        if ($user->parent_id == $parent_id || $admin->type = "super_admin") {
            $permissions = [];
            $actions = [];
            foreach ($user->permissions as $row) {
                if (strpos($row['name'], '.') !== false) {
                    $permissions[] = $row['name'];
                } else {
                    $actions[] = $row['name'];
                }
            }
            return response()->json([
                'status' => true,
                "message" => "success",
                'data' => [
                    'actions' => $actions,
                    'permissions' => $permissions,
                ],
            ]);
        } else {
            return json_response([], 200, false, trans('web.unauthorized'));
        }
    }

    public function SyncPermissionsFromBackOffice()
    {
        $response = $this->client->request('GET', 'users/user_permissions');
        $response = json_decode($response->getBody()->getContents());
        $data = $response->data;
        $actions = [];
        foreach ($data->Actions as $action) {
            if (!str_contains($action, 'users_')) {
                $actions[] = $action;
            }
        }
        $actions = array_unique($actions);
        $online_permissions = $data->Permissions;
        // var_dump($online_permissions);

        //formate Backoffice permissions
        $permissions = [];
        foreach ($online_permissions as $permission) {
            $suppliers = $permission->Suppliers;
            foreach ($suppliers as $supplier) {
                $id = $supplier->PermissionId;
                $permission_key = $supplier->PermissionKey;
                $permissions[] = $permission_key . '.' . $id;
            }
        }
        // Reset cached permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();
        // Get current permission and actions
        $current_permissions = Permission::where('type', 'b2b_permissions')->pluck('name')->toArray();
        $current_actions = Permission::where('type', 'b2b_actions')->pluck('name')->toArray();
        // New Permissions&Actions
        $newActions = array_diff($actions, $current_actions);
        $newPermissions = array_diff($permissions, $current_permissions);
        // Add New Permissions&actions  to local database
        foreach ($newPermissions as $permission) {
            Permission::create(['name' => $permission, 'guard_name' => 'sanctum', 'type' => 'b2b_permissions']);
        }
        foreach ($newActions as $action) {
            Permission::create(['name' => $action, 'guard_name' => 'sanctum', 'type' => 'b2b_actions']);
        }
        // Removed Permissions
        $removedPermissions = array_diff($current_permissions, $permissions);
        $removedActions = array_diff($current_actions, $actions);
        // Remove removedPermissions
        foreach ($removedPermissions as $permission) {
            Permission::where('name', $permission)->delete();
        }
        foreach ($removedActions as $action) {
            Permission::where('name', $action)->delete();
        }
        //assign permissions and actions to super_admin role
        $permissions = Permission::all()->pluck('name')->toArray();
        //assign all permissions to super_Admin Role
        $role = Role::findByName('super_admin');
        $role->syncPermissions($permissions);
        return response()->json([
            'message' => 'All Permissions Are Synchronized From Backoffice ',
            'status' => TRUE,
        ], 200);
    }

    public function update(Request $request, $id)
    {
        $user = User::find($id);
        $validatedData = $request->validate([
            'permissions' => 'array|nullable'
        ]);
        if ($user) {
            return response()->json([
                'status' => true,
                'message' => 'permission updated'
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'no user found'
            ]);
        }
        $user->syncPermissions($validatedData['permissions'] ?? []);
    }

    public function give_permission_to_user(Request $request, $id)
    {
        $parent_id = $request->get('parent');
        $type = User::where('id', $id)->first()->type;
        if ($type == 'company') {
            $company = User::find($request->id);
            app()[PermissionRegistrar::class]->forgetCachedPermissions();
            $actions = array_merge((array) $request->actions, (array) $request->permissions);
            $actions_string = implode(', ', $actions);
            $company_employees = User::where('parent_id', $company->id)->get();
            if ($actions) {
                //remove b2b company listing from this company
                $company_permissions = ['users_list_companies', 'users_add_company', 'users_update_company', 'users_list_companies_with_employees'];
                $actions = array_diff($actions, $company_permissions);
                //get old and removed permissions
                $companyOldPermissions = $company->getPermissionNames()->toArray();
                if (count($companyOldPermissions) != 0) {
                    $companyRemovedPermissions = array_diff($companyOldPermissions, $actions);
                    //check for removed permissions
                    if (count($companyRemovedPermissions) != 0) {
                        $company_roles = Role::where('user_id', $company->id)->pluck('id');
                        if ($company_roles->count() != 0) {
                            //get removed permissions ids
                            $companyOldPermissions_ids = [];
                            foreach ($companyRemovedPermissions as $permission) {
                                $raw = Permission::where('name', $permission)->first();
                                $companyOldPermissions_ids[] = $raw->id;
                            }
                            //remove permissions from company groups
                            $permission_to_delete = [];
                            foreach ($company_roles as $role) {
                                foreach ($companyOldPermissions_ids as $permission_id) {
                                    $permission_to_delete[] = DB::table('role_has_permissions')->where([['role_id', '=', $role], ['permission_id', '=', $permission_id]])->first();
                                }
                            }
                            foreach ($permission_to_delete as $permission) {
                                if ($permission != null) {
                                    DB::table('role_has_permissions')->where('role_id', $permission->role_id)->where('permission_id', $permission->permission_id)->delete();
                                }
                            }
                        }
                        //remove permissions from company's employees
                        if ($company_employees->count() != 0) {
                            foreach ($company_employees as $employee) {
                                $employee->revokePermissionTo($companyRemovedPermissions);
                            }
                        }
                    }
                }
            } else {
                //empty company's employees permissions
                foreach ($company_employees as $employee) {
                    $employee->syncPermissions([""]);
                }
            }

            if ($company->syncPermissions($actions)) {
                return json_response($actions_string, 200, true, trans('web.assigned_successfully'));
            }
        }

        if ($type == "employee") {
            $user = User::find($request->id);
            app()[PermissionRegistrar::class]->forgetCachedPermissions();
            $actions = array_merge((array) $request->actions, (array) $request->permissions);
            $actions_string = implode(', ', $actions);
            if ($user->syncPermissions($actions)) {
                // return json_response('', 200, true, 'The permissions ( ' . $actions_string . ') is assigned successfully');
                return json_response($actions_string, 200, true, trans('web.assigned_successfully'));
            }
        }
    }
}
