<?php

namespace Modules\Markup;

use Carbon\Carbon;
use Modules\Markup\Entities\Markup as MarkupModel;
use Modules\Users\Entities\User;

class Markup
{

    protected const TYPE_MOBILE = '_mobile';
    protected const TYPE_B2B = '_b2c';
    protected const TYPE_B2C = '_b2b';

    protected $device;
    protected $markups;
    protected $overwrite;

    public function __construct()
    {
        $this->markups = [];
        $this->overwrite = [];
    }

    protected function getDeviceType()
    {
        $headerValue = request()->header('X-App-Type');
        if ($headerValue == 'Mobile') {
            $this->device = self::TYPE_MOBILE;
        } else if ($headerValue == 'B2B') {
            $this->device = self::TYPE_B2B;
        } else if ($headerValue == 'B2C') {
            $this->device = self::TYPE_B2C;
        } else {
            $this->device = self::TYPE_B2C;
        }
    }

    protected function check($arr, $key)
    {
        if (isset($arr[$key]) && !empty($arr[$key])) {
            return true;
        }
    }

    public function prepare($data = [], $company_id) {
        $company = User::find($company_id);
        if($company->type == 'super_admin') {
            $this->prepareMarkups($data, $company_id);
        } else {
            $superAdmin = User::where(['type' => 'super_admin'])->first();
            $this->prepareMarkups($data, $superAdmin->id);
            $this->prepareMarkups($data, $company_id);
        }
    }
    
    public function prepareMarkups($data = [], $company_id)
    {
        if ($this->check($data, 'booking_date')) {
            $bookingDate = $data['booking_date'];
        } else {
            $bookingDate = null;
        }
        if ($this->check($data, 'reservation_date')) {
            $reservationDate = $data['reservation_date'];
        } else {
            $reservationDate = null;
        }
        $dateFilters = $this->getDateFilters($bookingDate, $reservationDate);
        if ($this->check($data, 'modules')) {
            $markups = MarkupModel::where([
                'model_type' => 'module',
            ])->whereIn(
                'model_name',
                $data['modules']
            )
            ->where('company_id', $company_id)
            ->where(function ($query) use ($dateFilters) {
                $query->where('ongoing', true);
                if (!empty($filters)) {
                    $query->orWhere($dateFilters);
                }
            })->get();
            if($markups->isNotEmpty() ) {
                $this->markups = array_merge($this->markups, $markups->all());
            }
        }

        if ($this->check($data, 'suppliers')) {
            $markups = MarkupModel::where([
                'model_type' => 'supplier',
            ])->whereIn(
                'model_id',
                $data['suppliers']
            )
            ->where('company_id', $company_id)
            ->where(function ($query) use ($dateFilters) {
                $query->where('ongoing', true);
                if (!empty($filters)) {
                    $query->orWhere($dateFilters);
                }
            })->get();
            if($markups->isNotEmpty() ) {
                $this->markups = array_merge($this->markups, $markups->all());
            }
        }
        if ($this->check($data, 'hotels')) {
            if ($this->check($data, 'suppliers')) {
                $markups = MarkupModel::where([
                    'model_type' => 'hotel',
                ])->whereIn(
                    'model_id',
                    $data['hotels']
                )
                    // ->whereIn(
                    //     'identifier->supplier_id',
                    //     $data['suppliers']
                    // )

                    ->where('company_id', $company_id)
                    ->where(function ($query) use ($dateFilters) {
                        $query->where('ongoing', true);
                        if (!empty($filters)) {
                            $query->orWhere($dateFilters);
                        }
                    })->get();
                if($markups->isNotEmpty() ) {
                    $this->markups = array_merge($this->markups, $markups->all());
                }
            }
        }

        if ($this->check($data, 'country_id')) {
            $this->markups[] = MarkupModel::where([
                'model_type' => 'country',
                'model_id' => $data['country_id']
            ])
            ->where('company_id', $company_id)
            ->where(function ($query) use ($dateFilters) {
                $query->where('ongoing', true);
                if (!empty($filters)) {
                    $query->orWhere($dateFilters);
                }
            })->first();
        }

        if ($this->check($data, 'cities')) {
            $markups = MarkupModel::where([
                'model_type' => 'city',
            ])->whereIn(
                'model_id',
                $data['cities']
            )
            ->where('company_id', $company_id)
            ->where(function ($query) use ($dateFilters) {
                $query->where('ongoing', true);
                if (!empty($filters)) {
                    $query->orWhere($dateFilters);
                }
            })->get();
            if($markups->isNotEmpty() ) {
                $this->markups = array_merge($this->markups, $markups->all());
            }
        }

        if ($this->check($data, 'airlines')) {
            $markups = MarkupModel::where([
                'model_type' => 'airline',
            ])->whereIn(
                'model_id',
                $data['airlines']
            )
            ->where('company_id', $company_id)
            ->where(function ($query) use ($dateFilters) {
                $query->where('ongoing', true);
                if (!empty($filters)) {
                    $query->orWhere($dateFilters);
                }
            })->get();
            if($markups->isNotEmpty() ) {
                $this->markups = array_merge($this->markups, $markups->all());
            }
        }

        if ($this->check($data, 'airports')) {
            $markups = MarkupModel::where([
                'model_type' => 'airport',
            ])->whereIn(
                'model_id',
                $data['airports']
            )
            ->where('company_id', $company_id)
            ->where(function ($query) use ($dateFilters) {
                $query->where('ongoing', true);
                if (!empty($filters)) {
                    $query->orWhere($dateFilters);
                }
            })->get();

            if($markups->isNotEmpty() ) {
                $this->markups = array_merge($this->markups, $markups->all());
            }
        }

        if ($this->check($data, 'company_id')) {
            $markup = MarkupModel::where([
                'model_type' => 'company',
                'model_id' => $data['company_id']
            ])
            ->where('company_id', $company_id)
            ->where(function ($query) use ($dateFilters) {
                $query->where('ongoing', true);
                if (!empty($filters)) {
                    $query->orWhere($dateFilters);
                }
            })->first();
            if($markup) {
                $this->markups[] = $markup;
            }
            if ($this->check($data, 'employee_id')) {
                $markup = MarkupModel::where([
                    'model_type' => 'employee',
                    'model_id' => $data['employee_id']
                ])
                ->where('company_id', $company_id)
                ->where(function ($query) use ($dateFilters) {
                    $query->where('ongoing', true);
                    if (!empty($filters)) {
                        $query->orWhere($dateFilters);
                    }
                })->first();
                if($markup) {
                    $this->markups[] = $markup;
                }
            }
        }
    }

    public function applyMarkups($amount, $data)
    {
        // dd($this->markups);
        $this->getDeviceType();
        $finalAmount = $amount;
        $markupsToApply = [];

        foreach ($this->markups as $markup) {
            if ($this->check($data, 'modules') and $markup->model_type == 'module' and in_array($markup->model_name, $data['modules'])) {
                $markupsToApply[] = $markup;
            }
            if ($this->check($data, 'supplier_id') and $markup->model_type == 'supplier' and $markup->model_id == $data['supplier_id']) {
                $markupsToApply[] = $markup;
            }
            if ($this->check($data, 'hotel_id') and $markup->model_type == 'hotel' and $markup->model_id == $data['hotel_id']) {
                // if ($this->check($data, 'supplier_id') and (int)$markup->identifier->supplier_id == $data['supplier_id']) {
                //     $markupsToApply[] = $markup;
                // }
                $markupsToApply[] = $markup;
            }
            // if ($this->check($data, 'country_id') and $markup->model_type == 'country' and $markup->model_id == $data['company_id']) {
            //     $markupsToApply[] = $markup;
            // }
            if ($this->check($data, 'city_id') and $markup->model_type == 'city' and $markup->model_id == $data['city_id']) {
                $markupsToApply[] = $markup;
            }
            if ($this->check($data, 'airline_id') and $markup->model_type == 'airline' and $markup->model_id == $data['airline_id']) {
                $markupsToApply[] = $markup;
            }
            if ($this->check($data, 'airports') and $markup->model_type == 'airport' and in_array($markup->model_id, $data['airports'])) {
                $markupsToApply[] = $markup;
            }
            if ($markup->model_type == 'company') {
                $markupsToApply[] = $markup;
            }
            if ($markup->model_type == 'employee') {
                $markupsToApply[] = $markup;
            }
        }
        // return $this->markups;
        // return $markupsToApply;
        // return $finalAmount;
        // return $data;
        // $overwrites = $this->getOverwrites($markupsToApply);

        $dominentMarkups = $this->getDominantMarkups();

        if (!empty($dominentMarkups)) {
            // return $dominentMarkups;
            foreach ($dominentMarkups as $markup) {
                $finalAmount += $this->applyMarkupToPrice($amount, $markup);
            }
        } else {
            foreach ($markupsToApply as $markup) {
                $finalAmount += $this->applyMarkupToPrice($amount, $markup);
            }
        }
        // return $overwrites;
        // foreach ($markupsToApply as $markup) {
        /**************************************
         * use if overwrites by markup id
         *************************************/

        // if (!in_array($markup->id, $overwrites)) {
        //     $finalAmount += $this->applyMarkupToPrice($amount, $markup);
        // }

        /**************************************
         * use if overwrites by level
         *************************************/

        // if (!in_array($markup->model_type, $overwrites)) {
        //     $finalAmount += $this->applyMarkupToPrice($amount, $markup);
        // }
        // }

        return $finalAmount;
        // return number_format($finalAmount, 2);
    }

    protected function applyMarkupToPrice($baseAmount, $markup)
    {
        $addition = 0;
        if ($markup->type == 'both') {
            $amountValue = $markup->{"amount{$this->device}"};
            $percentageValue = ($markup->{"percentage{$this->device}"} / 100 * $baseAmount);
            $addition = $amountValue + $percentageValue;
        } else if ($markup->type == 'amount') {
            $amountValue = $markup->{"amount{$this->device}"};
            $addition = $amountValue;
        } else if ($markup->type == 'percentage') {
            $percentageValue = ($markup->{"percentage{$this->device}"} / 100 * $baseAmount);
            $addition = $percentageValue;
        }
        return $addition;
    }

    protected function getDateFilters($bookingDate = null, $reservationDate = null)
    {
        $filters = [];
        if (!empty($bookingDate)) {
            $filters['booking_from'] = [
                'booking_from',
                '<',
                Carbon::parse($bookingDate)
            ];
            $filters['booking_to'] = [
                'booking_to',
                '>',
                Carbon::parse($bookingDate)
            ];
        }
        if (!empty($reservationDate)) {
            $filters['reservation_from'] = [
                'reservation_from',
                '<',
                Carbon::parse($reservationDate)
            ];
            $filters['reservation_to'] = [
                'reservation_to',
                '>',
                Carbon::parse($reservationDate)
            ];
        }
        return $filters;
    }

    protected function getOverwrites()
    {
        /********************************
         *
         * overwrites by markup ID
         *
         ********************************/

        // $overwrite = [];
        // foreach ($this->markups as $markup) {
        //     if ($markup->overwrite) {
        //         $overwrite[] = (int)$markup->id;
        //     }
        // }
        // return $overwrite;

        /********************************
         *
         * overwrites by Level
         *
         ********************************/

        $overwriteTypes = [];

        foreach ($this->markups as $markup) {
            if ($markup->overwrite) {
                if ($markup->model_type == 'supplier') {
                    $overwriteTypes[] = 'module';
                }
                if ($markup->model_type == 'hotel') {
                    $overwriteTypes[] = 'supplier';
                }
                if ($markup->model_type == 'airline') {
                    $overwriteTypes[] = 'supplier';
                }
                if ($markup->model_type == 'city') {
                    $overwriteTypes[] = 'country';
                }
                if ($markup->model_type == 'employee') {
                    $overwriteTypes[] = 'company';
                }
            }
        }
        return $overwriteTypes;
    }

    /**
     * return dominent markups if exists or false
     *
     * @return array|bool
     */
    protected function getDominantMarkups()
    {
        $allDominant = [];

        $dominantHotel = null;
        $dominantSupplier = null;
        $dominantCity = null;
        $dominantAirline = null;
        $dominantAirport = null;
        $markupCompany = null;
        $markupEmployee = null;
        $dominantEmployee = null;

        foreach ($this->markups as $markup) {
            if ($markup->overwrite) {
                if ($markup->model_type == 'supplier') {
                    $dominantSupplier = $markup;
                }
                if ($markup->model_type == 'hotel') {
                    $dominantHotel = $markup;
                }
                if ($markup->model_type == 'airline') {
                    $dominantAirline = $markup;
                }
                if ($markup->model_type == 'airport') {
                    $dominantAirport = $markup;
                }
                if ($markup->model_type == 'city') {
                    $dominantCity = $markup;
                }
                if ($markup->model_type == 'employee') {
                    $dominantEmployee = $markup;
                }
            } else {
                if ($markup->model_type == 'company') {
                    $markupCompany = $markup;
                }
                if ($markup->model_type == 'employee') {
                    $markupEmployee = $markup;
                }
            }
        }

        // add dominant markups if exists
        if($dominantHotel){$allDominant[] = $dominantHotel;}
        else if($dominantCity){$allDominant[] = $dominantCity;}
        else if($dominantAirport){$allDominant[] = $dominantAirport;}
        else if($dominantAirline){$allDominant[] = $dominantAirline;}
        else if($dominantSupplier){$allDominant[] = $dominantSupplier;}

        // if no dominent markups return false to the normal way and apply all markups
        if(empty($allDominant)) {
            return false;
        }

        // if dominent markups exists append dominent emplyee markup or if not add company and employee
        if($dominantEmployee){
            $allDominant[] = $dominantEmployee;
        }
        else {
            if($markupCompany) {
                $allDominant[] = $markupCompany;
            }
            if($markupEmployee) {
                $allDominant[] = $markupEmployee;
            }
        }
        return $allDominant;
    }
}
