<?php

namespace Modules\Locales\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Flights\Entities\Airline;
use Modules\Flights\Entities\Airport;

class Country extends Model
{
    protected $table = "countries";
    public $timestamps = false;
    protected $fillable = [
        'name',
        'code',
    ];
    protected $casts = [
        'name' => 'array',
    ];

    public function airlines()
    {
        return $this->hasMany(Airline::class, 'country_code', 'code');
    }

    public function airports()
    {
        return $this->hasMany(Airport::class, 'country_code', 'code');
    }
}
