<?php

namespace Modules\Flights\Http\Controllers;

use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\BadResponseException;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Common\Entities\Session;
use Modules\Flights\Entities\Flight;
use Modules\Markup\Markup;
use Modules\Payments\Entities\Payment;

class FlightsController extends Controller
{
    public $client;
    public function __construct(Request $req)
    {
        $headers = [
            // 'X-Authorization-Token' =>  env('API_TOKEN'),
            'Authorization' => 'Bearer ' . env('API_TOKEN'),
            'X-Language-Code' => $req->header('X-Language-Code'),
            'X-Country-Code' => $req->header('X-Country-Code'),
            'X-Currency-Code' => $req->header('X-Currency-Code'),
            'X-Client-IP' => $req->ip(),
        ];

        if ($req->header('X-Session')) {
            $headers['X-Session'] = $req->header('X-Session');
        }

        $this->client = new Client([
            'base_uri' => env('API_MODULE_BASE'),
            'headers' => $headers,
        ]);
    }

    public function auto_complete($query)
    {
        $response = $this->client->request('GET', 'flights/auto_complete/' . $query);
        return response((string) $response->getBody());
    }

    public function search(Request $req, Markup $engine)
    {
        // $user_settings = getUserSettings();
        // $timeout = $user_settings->search_timeout ?? 0;
        $response = $this->client->post('flights/search', [
            'json' => $req->input(),
            // 'timeout' => $timeout,
        ]);
        // return $response;
        if ($response->getStatusCode() !== 200) {
            return json_response(null, 200, false, trans('web.timeout_process_error'));
        }
        $body = json_decode($response->getBody()->getContents());

        if (!isset($body->sessions)) {
            return json_response(null, 200, false, trans('web.no_result'));
        }
        $sessions = $body->sessions;
        $query = $req->input();
        if (empty($sessions)) {
            return $body;
        }

        $flights = $body->data;
        $airline_list = $body->airline_list;
        $airport_list = $body->airport_list;

        $supplierIDS = collect($flights)
            ->pluck('Options.0.BookingInfo.SupplierId')
            ->unique()
            ->all();

        $company_id = $query['parent'] ?? 1;

        $user_id = $req->user()->id;

        $engine->prepare([
            'modules' => ['Flights'],
            'suppliers' => $supplierIDS,
            'airlines' => $airline_list,
            'airports' => $airport_list,
            'company_id' => $company_id,
            'employee_id' => $user_id,
        ], $company_id);


        $body->data = collect($flights)
            ->map(function ($flight, $flightIndex) use ($engine, $query, $body, $supplierIDS, $airline_list, $airport_list) {
                $option = $flight->Options[0];
                $session = $flight->Session;
                $supplierID = $session->SupplierId;
                $leg = $option->Legs[0];

                // $airlineCode = $leg->AirlineDetails->AirlineCode;
                // $airlineID = $airline_list[$airlineCode]->Key;

                // $airportCodes = [];

                // $OriginAirportCode = $leg->Origin->AirportCode;
                // $OriginAirportID = $airport_list[$OriginAirportCode]->Key ?? '';

                // if ($OriginAirportID) {
                //     $airportCodes[] = $OriginAirportID;
                // }

                // $DestAirportCode = $leg->Destination->AirportCode;
                // $DestAirportID = $airport_list_assoc[$DestAirportCode]->Key ?? '';

                // if ($DestAirportID) {
                //     $airportCodes[] = $DestAirportID;
                // }

                $flight->AmountOld = $flight->Amount;

                $flight->Amount = $engine->applyMarkups($flight->Amount, [
                    'modules' => ['Flights'],
                    'supplier_id' => $supplierID,
                    // 'airline_id' => $airlineID,
                    // 'airports' => $airportCodes,
                ]);

                Session::updateOrCreate(
                    [
                        'module' => 'flights',
                        'wow_session_key' => $session->WowSessionKey,
                    ],
                    [
                        'query' => $query,
                        'data' => [
                            // 'amount' => $flight->Amount,
                            'module' => 'flights',
                            'supplierID' => $supplierID,
                            // 'booking_id' => '',
                            'currency' => $flight->Currency,
                            'airline_list' => $body->airline_list,
                            'airport_list' => $body->airport_list,
                        ],
                    ]
                );

                return $flight;
            })
            ->all();
        return $body;
    }

    public function select_flight(Request $req)
    {
        $response = $this->client->post('flights/select_flight', ['json' => $req->all()]);
        $body = json_decode($response->getBody()->getContents());
        return $body;
        $session = get_Session_data($req);

        // $session->data = [
        //     'supplierID' => $body->Info->SupplierID,
        //     'airline_list' => $session->data['airline_list'],
        //     'airport_list' => $session->data['airport_list'],
        // ];
        // $session->save();
        // return response((string) $response->getBody());
    }

    public function pricing(Request $req)
    {
        $response = $this->client->post('flights/pricing', ['json' => $req->all()]);
        $body = json_decode($response->getBody()->getContents());
        // return $body;
        $data = $body->data;
        $legs = $body->data->Legs;

        //Apply Markup
        $session = get_Session_data($req);
        //get airlines and airports codes from session
        // $session_airline_list = $session->data['airline_list'];
        // $session_airport_list = $session->data['airport_list'];
        // $session_airline_list_key = array_unique(array_column($session_airline_list, 'Key'));
        // $session_airport_list_key = array_unique(array_column($session_airport_list, 'Key'));

        // $airline_list_assoc = [];
        // foreach ($session_airline_list as $airline) {
        //     $airline_list_assoc[$airline['Code']] = $airline;
        // }

        // $airport_list_assoc = [];
        // foreach ($session_airport_list as $airport) {
        //     $airport_list_assoc[$airport['Code']] = $airport;
        // }

        //current flight airlines
        // foreach ($legs as $leg) {
        //     $airlineCodes[] = $leg->AirlineDetails->AirlineCode;
        //     $airportCodes[] = $leg->Destination->AirportCode;
        //     $origin_airportCodes[] = $leg->Origin->AirportCode;
        // }

        // $airlinecode_list = array_unique($airlineCodes);
        // $airportcode_list = array_unique($airportCodes);
        // $origin_airportcode_list = array_unique($origin_airportCodes);

        // foreach ($airlinecode_list as $airlineCode) {
        //     $airlineIDS[] = isset($airline_list_assoc[$airlineCode]) ? $airline_list_assoc[$airlineCode]['Key'] : '';
        // }

        // foreach ($airportcode_list as $airportCode) {
        //     $airportIDS[] = isset($airport_list_assoc[$airportCode]) ? $airport_list_assoc[$airportCode]['Key'] : '';
        // }
        // foreach ($origin_airportcode_list as $origincode) {
        //     $airportIDS[] = isset($airport_list_assoc[$origincode]) ? $airport_list_assoc[$origincode]['Key'] : '';
        // }
        // $airportIDS = array_unique($airportIDS);

        $supplierIDs[] = $session->data['supplierID'];
        $company_id = $req->get('parent');
        $user_id = $req->user()->id;
        $engine = new Markup();
        $engine->prepare([
            'modules' => ['Flights'],
            'suppliers' => $supplierIDs,
            // 'airlines' => $airlineIDS,
            // 'airports' => $airportIDS,
            'company_id' => $company_id,
            'employee_id' => $user_id,
            // 'reservation_date' => $query['checkin'],
            // 'booking_date' => date('Y-m-d')
        ], $company_id);
        $body->data->AmountOld = $data->Amount;
        $body->data->Amount = $engine->applyMarkups($data->Amount, [
            'modules' => ['Flights'],
            'supplier_id' => $supplierIDs[0],
            // 'airline_id' => $airlineIDS[0],
            // 'airports' => $airportIDS,
        ]);
        //update session with old amount and amount after markup
        $session->data = [
            'amount_old' => $body->data->AmountOld,
            'amount' => $body->data->Amount,
            'currency' => $body->data->Currency,
            'supplierID' => $session->data['supplierID'],
            'airline_list' => $session->data['airline_list'],
            'airport_list' => $session->data['airport_list'],
        ];
        $session->save();
        return $body;
    }

    public function book(Request $req)
    {
        // try {
        //     $response = $this->client->post('flights/book', ['json' => $request->all()]);
        //     $data = json_decode($response->getBody(), true);
        //     // return $data->data->BookingData;
        //     $this->upsertBooking($data['data']['BookingData']);
        //     return response()->json($data);
        // } catch (BadResponseException $e) {
        //     $response = $e->getResponse();
        //     $jsonBody = $response->getBody()->getContents();
        //     // Handle the error response appropriately
        //     return response()->json(['error' => $jsonBody], $response->getStatusCode());
        // }

        try {
            $response = $this->client->post('flights/book', ['json' => $req->all()]);
            $body = json_decode((string) $response->getBody()->getContents());
            if ($body->status == true) {
                $session = get_Session_data($req);
                $data = $body->data;
                $amount = $session->data['amount'];
                $amount_old = $session->data['amount_old'];
                $data->amount = $amount;
                $data->amount_old = $amount_old;
                $user = createUser($data->user);
                $data->user = $user;
                $this->upsert_booking($data);
                return json_response($data);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'book failed ' . $body->message,
                ]);
            }
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'book failed ' . $e->getMessage(),
            ]);
        }
    }

    private function upsert_booking($data)
    {
        try {
            $parent_id = request()->get('parent') ?? 1;
            $booking = Flight::updateOrCreate([
                'user_id' => $data->user->id,
                'wow_merchant_ref' => $data->merchant_ref,
            ], [
                'user_data' => '',
                'amount' => $data->amount,
                'company_id' => $parent_id,
                'original_amount' => $data->amount_old,
                'adult_count' => $data->BookingData->booking_details->BookingNeededInfo->SearchRequest->AdultCount,
                'child_count' => $data->BookingData->booking_details->BookingNeededInfo->SearchRequest->ChildCount,
                'infant_count' => $data->BookingData->booking_details->BookingNeededInfo->SearchRequest->InfantCount,
                'booking_details' => $data->BookingData->booking_details,
                'booking_id' => $data->BookingId,
                'payment_status' => Payment::STATUS_UNPAID,
                'supplier_name' => $data->SupplierName,
                'payment_deadline' => $data->BookingData->payment_deadline ?? '',
                'booking_status' => $data->BookingData->booking_status,
                'ticket_status' => $data->BookingData->ticket,
                'pnr' => $data->BookingData->pnr,
                'ip_address' => '',
                'is_lcc' => $data->BookingData->is_lcc,
                'is_refund_allowed' => $data->BookingData->is_refund_allowed,
                'is_reissue_allowed' => $data->BookingData->is_reissue_allowed,
                'is_online_refund_allowed' => $data->BookingData->is_online_refund_allowed,
                'is_void_allowed' => $data->BookingData->is_void_allowed,
                'currency_code' => $data->BookingData->booking_details->BookingInfo->CurrencyCode,
                'email' => $data->user->email,
                'mobile' => $data->user->phone,
                'legs' => $data->BookingData->booking_details->BookingNeededInfo->Legs,
            ]);
            //record payment
            $payment = $this->update_payment([
                'booking_id' => $booking->id,
                'company_id' => $parent_id,
                'user_id' => $data->user->id,
                'merchant_ref' => $data->merchant_ref,
                'supplier' => $data->SupplierName,
                // 'user_id' => $data->user->id,
                'module' => 'flights',
                'type' => 'debit',
                'amount' => $data->amount,
                'status' => Payment::STATUS_UNPAID,
                'currency' => $data->BookingData->booking_details->BookingInfo->CurrencyCode
            ]);

            //update payment
            $booking->update([
                'payment_id' => $payment->id
            ]);
            $booking->save();
        } catch (Exception $e) {
            throw new Exception('error in upserting ' . $e->getMessage());
        }
    }

    //update Payment
    public function update_payment($data)
    {
        $payment = Payment::updateOrCreate(
            [
                'booking_id' => $data['booking_id'],
                'merchant_ref' => $data['merchant_ref'],
            ],
            $data
        );

        return $payment;
    }

    public function pre_payment($merchant_ref, Request $req)
    {
        // $currency = getBaseCurrency();
        // $book = Flight::where('wow_merchant_ref', $merchant_ref)->first();
        // if ($book && $book->booking_status != 'Ticketed') {
        // $response = $this->client->get('flights/pre_payment/' . $merchant_ref);
        // $data = json_decode($response->getBody()->getContents());
        //     // $session = get_Session_data($req);
        //     // $amount = updateCurrencyRate($session->data['amount'], $currency);
        //     // $amount_old = updateCurrencyRate($session->data['amount_old'], $currency);
        //     // $data->data->PaymentInfo->Price->Amount = $amount;
        //     // $data->data->PaymentInfo->Price->Currency = $currency;
        //     // $data->data->PaymentInfo->Price->Amount_old = $amount_old;
        //     // // if ($req->user()->type != 'super_admin') {
        // $data->data->PaymentInfo->Credit->UserCredits = $req->user()->credit_amount;
        // $data->data->PaymentInfo->Credit->CreditCurrency =  $currency;
        //     // }
        //     return $data;
        // }

        // return json_response(['PaymentInfo' => [
        //     'Ref' => $merchant_ref,
        //     'Status' => 'Paid',
        // ]], 200, true, 'this booking is paid');
        try {
            if (!$merchant_ref) {
                return new Exception('Merchant_Ref is required');
            }
            $booking = Flight::where('wow_merchant_ref', $merchant_ref)->first();
            $data['PaymentInfo'] = [
                'Ref' =>  $merchant_ref,
                'Status' =>  $booking->payment_status,
                'MerchantRef' =>  'flights.' . $merchant_ref,
                'Module' => 'flights',
                'Price' => [
                    'Amount' => $booking->amount,
                    'Currency' => $booking->currency_code
                ],
            ];
            $data['PaymentInfo']['Credit']['UserCredits'] = $req->user()->credit_amount;
            return json_response($data);
        } catch (Exception $e) {
            return json_response([
                'status' => false,
                'message' => 'Payment details failed' . $e->getMessage(),
                'data' => []
            ]);
        }
    }

    // public function pay_from_balance($merchant_ref, Request $req)
    // {
    //     // $book = Flight::where('wow_merchant_ref', $merchant_ref)->first();
    //     // if ($book && $book->booking_status != 'Ticketed') {
    //     //     $price = get_price($req);
    //     //     //check current user balance
    //     //     if (check_Balance($req, $price)) {
    //     //         $response = $this->client->post('flights/pay_from_balance/' . $merchant_ref, ['json' => $req->all()]);
    //     //         // $response = json_decode((string) $response->getBody(),true);
    //     //         return $response->status;

    //     //         // return response((string) $response->getBody());
    //     //         $this->upsert_booking($merchant_ref, $req);
    //     //         update_balance($req, $price);
    //     //         // recordPayment($req, $merchant_ref);
    //     //         return response((string) $response->getBody());
    //     //     } else {
    //     //         return json_response(null, 200, false, trans('web.low_balance'));
    //     //     }
    //     // }
    //     $book = Flight::where('wow_merchant_ref', $merchant_ref)->first();
    //     if ($book && $book->booking_status != 'Ticketed') {
    //         $price = get_price($req);
    //         //check current user balance
    //         if (check_Balance($req, $price)) {
    //             $response = $this->client->post('flights/pay_from_balance/' . $merchant_ref, ['json' => $req->all()]);
    //             $response_body = json_decode((string) $response->getBody(), true);
    //             if (isset($response_body['status'])) {
    //                 $status = $response_body['status'];
    //                 if ($status == 'true') {
    //                     $this->upsert_booking($merchant_ref, $req);
    //                     update_balance($req, $price);
    //                     return response((string) $response->getBody());
    //                 } else {
    //                     return json_response(null, 200, false, trans('web.payment_failed'));
    //                 }
    //             } else {
    //                 return json_response(null, 200, false, trans('web.invalid_response'));
    //             }
    //         } else {
    //             return json_response(null, 200, false, trans('web.low_balance'));
    //         }
    //     }
    // }
    /**
     * Pay for a flight booking using the user's balance.
     *
     * @param string $merchant_ref The merchant reference number for the flight booking.
     * @param Request $req The HTTP request object containing the payment details.
     * @return JsonResponse The JSON response indicating the result of the payment.
     */
    public function pay_from_balance(string $merchant_ref, Request $req)
    {
        $booking = Flight::where('wow_merchant_ref', $merchant_ref)->first();
        $payment = Payment::where('booking_id', $booking->id)->first();
        if ($booking && $booking->booking_status !== Payment::STATUS_UNPAID) {
            $price = $booking->original_amount;
            if (check_balance($req, $price)) {
                $response = $this->client->post('flights/pay_from_balance/' . $merchant_ref, ['json' => $req->all()]);
                $responseBody = json_decode((string) $response->getBody(), true);
                if (isset($responseBody['status']) && $responseBody['status'] === true) {
                    $booking->update([
                        'booking_status' => 'Confirmed',
                        'payment_status' => Payment::STATUS_PAID
                    ]);
                    $booking->save();
                    $payment->update([
                        'status' => Payment::STATUS_PAID
                    ]);
                    $payment->save();
                    update_balance($req, $price);
                    return response((string) $response->getBody());
                } else {
                    return json_response(null, 200, false, trans('web.payment_failed') . ' - ' . $responseBody['message']);
                }
            } else {
                return json_response(null, 200, false, trans('web.low_balance'));
            }
        } else {
            return json_response(null, 200, false, trans('error in Payment'));
        }
    }
    public function booking_list(Request $req)
    {
        $response = $this->client->post('flights/local_booking_list/?page=' . $req->get('page') ?? 1, ['json' => $req->all()]);
        return response((string) $response->getBody());
    }

    // for b2c
    public function payment_details($merchant_ref, Request $req)
    {
        $response = $this->client->get("flights/payment_details/$merchant_ref");
        return response((string) $response->getBody());
    }

    public function getBookingDetails($merchant_ref, Request $req)
    {
        $response = $this->client->get('flights/local_booking_details/' . $merchant_ref);
        $book = Flight::where('wow_merchant_ref', $merchant_ref)->first();
        $body = json_decode((string) $response->getBody(), true);
        if ($book) {
            $body['data']['Amount'] = $book->amount;
            $body['data']['OriginalAmount'] = $book->original_amount;
        } else {
            $session = get_Session_data($req);
            if ($session) {
                $body['data'] = $session['query'];
                $body['data']['Amount'] = $session->data['amount'];
                $body['data']['OriginalAmount'] = $session->data['amount_old'];
            }
        }
        // return $body;
        return json_decode((string) $response->getBody(), true);
    }

    public function booking_details($merchant_ref)
    {
        // $response = $this->client->get('flights/booking_details/' . $merchant_ref);
        // return $response;

        $book = Flight::with('user')->where('wow_merchant_ref', $merchant_ref)->first();
        $responseData = [
            'first_name' => $book->user->first_name,
            'email' => $book->user->email,
            'passengers' => $book->booking_details['Booking']['Request']['booking']['passengers'],
            'legs' => $book->booking_details['BookingNeededInfo']['Legs'],
            'booking_id' => $book->id,
            'amount' => $book->amount,
            'currencyCode' => $book->currency_code,
            'adultCount' => $book->adult_count,
            'childCount' => $book->child_count,
            'infantCount' => $book->infant_count,

        ];
        // $book->UserData = $book->user;
        // $book->Details = $book->booking_details;
        // $book->Passengers = $book->booking_details['Booking']['Request']['booking']['passengers'];
        // $body['data']['Amount'] = $book->amount;
        // $body['data']['OriginalAmount'] = $book->original_amount;
        return json_response($responseData);
    }

    public function country_list(Request $req)
    {
        $response = $this->client->get('flights/country_list', ['json' => $req->all()]);
        return response((string) $response->getBody());
    }

    public function nationality_list(Request $req)
    {
        $response = $this->client->get('flights/nationality_list', ['json' => $req->all()]);
        return response((string) $response->getBody());
    }

    public function local_booking_details($merchant_ref, Request $req)
    {
    }

    private function upsertBooking($data)
    {
        $parent_id = request()->get('parent') ?? 1;
        if ($data) {
            $updateData = [
                'user_id' => Auth::id(),
                'company_id' => $parent_id,
                'wow_merchant_ref' => $data['merchant_ref'],
                'adult_count' => $data['booking_details']['BookingNeededInfo']['SearchRequest']['AdultCount'],
                'child_count' => $data['booking_details']['BookingNeededInfo']['SearchRequest']['ChildCount'],
                'infant_count' => $data['booking_details']['BookingNeededInfo']['SearchRequest']['InfantCount'],
                'booking_details' => $data['booking_details'],
                'payment_status' => 'Pending',
                'payment_deadline' => $data['payment_deadline'],
                'supplier_name' => $data['booking_details']['BookingNeededInfo']['Supplier'],
                'booking_status' => $data['booking_status'],
                'ticket_status' => 'Pending',
                'pnr' => $data['pnr'],
                'ip_address' => $data['booking_details']['ip_address'],
                'is_lcc' => $data['is_lcc'] ?? 0,
                'is_refund_allowed' => $data['is_refund_allowed'] ?? 0,
                'is_reissue_allowed' => $data['is_reissue_allowed'] ?? 0,
                'is_online_refund_allowed' => $data['is_online_refund_allowed'] ?? 0,
                'is_void_allowed' => $data['is_void_allowed'] ?? 0,
                'currency_code' => $data['booking_details']['BookingInfo']['CurrencyCode'],
                'amount' => $data['booking_details']['BookingInfo']['Amount'],
                'original_amount' => $data['booking_details']['BookingInfo']['Amount'],
            ];

            $contactsData = request()->ContactsData;

            // Check if the 'title' field exists in the request data
            if (isset($contactsData['title'])) {
                $updateData['title'] = $contactsData['title'];
            }

            // Check if the 'first_name' field exists in the request data
            if (isset($contactsData['first_name'])) {
                $updateData['first_name'] = $contactsData['first_name'];
            }

            // Check if the 'last_name' field exists in the request data
            if (isset($contactsData['last_name'])) {
                $updateData['last_name'] = $contactsData['last_name'];
            }

            // Check if the 'email' field exists in the request data
            if (isset($contactsData['email'])) {
                $updateData['email'] = $contactsData['email'];
            }

            // Check if the 'mobile' field exists in the request data
            if (isset($contactsData['mobile']['full_number'])) {
                $updateData['mobile'] = $contactsData['mobile']['full_number'];
            }

            Flight::updateOrCreate(
                ['user_id' => Auth::id(), 'company_id' => $parent_id, 'wow_merchant_ref' => $data['merchant_ref']],
                $updateData
            );
        }
    }

    public function local_booking_list(Request $req)
    {
        $company_id = $req->get('parent');
        $user = Auth::user();
        $query = [
            'user' => function ($q) {
                $q->select('id', 'type', 'image', 'first_name', 'last_name', 'company');
            },
            'company' => function ($q) {
                $q->select('id', 'type', 'image', 'company');
            },
        ];
        if ($user->type == 'super_admin') {
            $list = Flight::with($query)->orderBy('id', 'DESC')->jsonPaginate();
        } elseif ($user->type == 'company') {
            $list = Flight::with(['user' => $query['user']])->where('company_id', $company_id)->orderBy('id', 'DESC')->jsonPaginate();
        } else {
            $list = Flight::with(['user' => $query['user']])->where('user_id', $user->id)->orderBy('id', 'DESC')->jsonPaginate();
        }
        return json_response_pagination($list);
    }

    //get remote booking list from wow backoffice for that b2b client
    public function remote_booking_list(Request $req)
    {
        $response = $this->client->post('hotels/local_booking_list/?page=' . $req->get('page') ?? 1, ['json' => $req->all()]);
        return response((string) $response->getBody());
    }

    public function cancel_booking($merchant_ref)
    {
        $book = Flight::where('wow_merchant_ref', $merchant_ref)->first();
        return $book;
    }
    public function PkFareTicketPush(Request $req)
    {
        $data = $req->all();
        $timestamp = date('YmdHis');
        $filename = 'data_' . $timestamp . '.json';
        $directory = storage_path('app/pkfare');
        if (!is_dir($directory)) {
            mkdir($directory, 0755, true);
        }
        $path = $directory . '/' . $filename;
        if (file_exists($path)) {
            $contents = json_decode(file_get_contents($path), true);
        } else {
            $contents = [];
        }
        $contents[] = $data;
        file_put_contents($path, json_encode($contents));
        return json_response($data, 200, true, 'Ticket Request Received Successfully');
    }
}
