<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="robots" content="">
    <meta name="description" content="<?php echo e(__('CryptoZone - Crypto Trading HTML Template')); ?>">
    <meta property="og:title" content="<?php echo e(__('CryptoZone - Crypto Trading HTML Template')); ?>">
    <meta property="og:description" content="<?php echo e(__('CryptoZone - Crypto Trading HTML Template')); ?>">
    <meta property="og:image" content="">
    <meta name="format-detection" content="telephone=no">
    
    <!-- FAVICONS ICON -->
    <?php if(config('Site.favicon')): ?>
        <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('storage/configuration-images/'.config('Site.favicon'))); ?>">
    <?php else: ?> 
        <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('images/favicon.png')); ?>">
    <?php endif; ?>
    
    <!-- PAGE TITLE HERE -->
    <title><?php echo e(config('Site.title') ? config('Site.title') : __('wowws Laravel')); ?></title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Custom Stylesheet -->
    <link rel="stylesheet" href="<?php echo e(asset('front/css/style.css')); ?>">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap">

</head>
<body class="vh-100">
    <div class="authincation h-100">
        <div class="container h-100">
            <div class="row justify-content-center h-100 align-items-center">
                <div class="col-md-5">
                    <div class="form-input-content text-center error-page">
                        <h1 class="error-text  font-weight-bold"><?php echo e(__('403')); ?></h1>
                        <h4><i class="fa fa-times-circle text-danger"></i> <?php echo e(__('Forbidden Error!')); ?></h4>
                        <p><?php echo e(__('You do not have permission to view this resource.')); ?></p>
            			<div>
                            <a class="btn btn-primary" href="<?php echo e(url('/admin')); ?>"><?php echo e(__('Back to Home')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html><?php /**PATH /var/www/html/resources/views/errors/403.blade.php ENDPATH**/ ?>