<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Payments\Entities\Payment;

class FlightsBookingList extends Model
{
    use HasFactory;
    protected $table = 'flights_booking_list';
    protected $fillable = [
        'id',
        'company_id',
        'customer_id',
        'supplier_id',
        'pnr',
        'order_num',
        'ticket',
        'booking_status',
        'payment_id',
        'booking_details',
        'session_id',
        'session_key',
        'supplier_session_id',
        'payment_deadline',
        'is_lcc',
        'is_reissue_allowed',
        'is_refund_allowed',
        'is_online_refund_allowed',
        'is_void_allowed',
        'amount',
        'original_amount',
        'currency_code',
        'notes',
        'response',
        'published',
        'is_deleted',
        'updated_by',
    ];
    protected $casts = [
        'notes' => 'json',
        'response' => 'json',
        'ticket' => 'json',
        'booking_details' => 'json'
    ];
    protected $appends = ['user', 'company', 'supplier', 'payment'];

    public function getUserAttribute()
    {
        $user = Customer::find($this->attributes['customer_id']);
        return $user ? $user : null;
    }
    public function getCompanyAttribute()
    {
        $company = User::with('balance')->find($this->attributes['company_id']);
        return $company ? $company : null;
    }
    public function getSupplierAttribute()
    {
        $supplier = Supplier::find($this->attributes['supplier_id']);
        return $supplier ? $supplier : null;
    }

    public function getPaymentAttribute()
    {
        $payment = Payment::find($this->attributes['payment_id']);
        return $payment ? $payment : null;
    }
}
