<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\Models\Blog;
use App\Models\Page;
use App\Models\Role;
use App\Models\User;
use App\Models\BlogCategory;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    
    /*
    *  Display dashboard for admin panel
    */
    public function dashboard()
    {   
        $page_title = __('Dashboard');
        $rolescount = Role::get()->count();
        $userscount = User::get()->count();
      
        $users_query = User::selectRaw('CONCAT_WS("-", MONTHNAME(created_at),YEAR(created_at)) monthyear, count(*) data');
        $users = $users_query->groupBy('monthyear')->orderBy('created_at', 'asc')->get();

        $users_monthyear = $users->pluck('monthyear');
        $users_count = $users->pluck('data');
        $max_user_count = max($users_count->toArray());
        $max_user_count = ($max_user_count <= 1) ? $max_user_count + 3 : $max_user_count + 1 ; 
        
        return view('admin.dashboard',compact('rolescount','userscount','users_monthyear','users_count','max_user_count','page_title'));
    }
}
