<?php

use App\Models\Logs;
use App\Models\Supplier;
use App\Models\User;
use App\Models\WowSession;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

function get_supplier_id($key)
{
    $supplier = Supplier::where('key', $key)->first();
    return $supplier->id;
}
function xml2Array($xml)
{
    $xml = simplexml_load_string($xml);
    $json = json_encode($xml);
    $array = json_decode($json, true);
    return $array;
}
// file saving
function save_to_file($file_name, $module, $supplier, $content)
{
    // if (env(strtoupper($module) . '_' . strtoupper($supplier) . '_REQUESTS_STORE')) {
    //     $path = storage_path('app/Supplier_Requests/' . ucfirst($module) . '/' . ucfirst($supplier));
    //     // Check if the directory exists or create it recursively
    //     if (!is_dir($path)) {
    //         mkdir($path, 0777, true);
    //     }
    //     $file_path = $path . '/' . $file_name;

    //     $fp = fopen($file_path, 'w');
    //     fwrite($fp, json_encode($content));
    //     fclose($fp);
    // }
}

//session handling
function generate_session_key()
{
    $key = Str::uuid()->toString();
    // Check if the key already exists
    $found = WowSession::where('key', $key)->first();

    // Regenerate a new key until a unique one is found
    while ($found) {
        $key = Str::uuid()->toString();
        $found = WowSession::where('key', $key)->first();
    }
    return $key;
}

function set_session($module, $supplier, $key, $query, $data = null)
{
    $attributes = [
        'key' => $key,
        'module' => $module,
        'supplier' => $supplier,
    ];
    $dataFields = [];
    if ($query !== null) {
        $dataFields['query'] = $query;
    }

    if ($data !== null) {
        $dataFields['data'] = $data;
    }

    return WowSession::updateOrCreate($attributes, $dataFields);
}



function get_module_session($key)
{
    $session = WowSession::where('key', $key)->first();
    return $session;
}

function set_module_search($module, $session, $query, $data, $company_id)
{
    $className = 'Modules\\' . $module . '\\Entities\\' . ucfirst($module) . 'Search';
    if (class_exists($className)) {
        $model = app($className); // Load the model dynamically
        $model::updateOrCreate(
            [
                'session_id' => $session,
            ],
            [
                'company_id' => $company_id,
                'query' => $query,
                'data' => $data
            ]
        );
    }
}

//store logs
function store_logs($data)
{
    // $requiredKeys = ['user_id', 'company_id', 'type', 'module', 'supplier', 'booking_id', 'file', 'content', 'ip_address'];
    Logs::create([
        'user_id' => isset($data['user_id']) ? $data['user_id'] : '',
        'company_id' => isset($data['company_id']) ? $data['company_id'] : '',
        'type' => isset($data['type']) ? $data['type'] : '',
        'module' => $data['module'],
        'supplier' => $data['supplier'],
        'booking_id' => isset($data['booking_id']) ? $data['booking_id'] : '',
        'file' => isset($data['file']) ? $data['file'] : '',
        'content' => $data['content'],
        'ip_address' => isset($data['ip_address']) ? $data['ip_address'] : ''
    ]);
}

function explode_merchant_ref($merchant_ref)
{
    list($module_key, $booking_id, $user_id) = explode(".", $merchant_ref);
    return [
        'module_key' => $module_key,
        // 'supplier_key' => $supplier_key,
        'booking_id' => $booking_id,
        'user_id' => $user_id,
        // 'company' => $company,
        // 'random' => $random
    ];
}
