<?php

//merchant ref 

use App\Models\FlightsBookingList;

function get_booking_by_merchant_reference($merchantReference)
{
    $merchantRefData = get_merchant_ref($merchantReference);
    if (!$merchantRefData) {
        return false;
    }
    $booking = FlightsBookingList::where('id', $merchantRefData['booking_id'])->first();
    return $booking ?? false;
}

function get_merchant_ref($merchantReference)
{
    list($booking_id, $user_id) = explode(".", $merchantReference, 2);
    return [
        'booking_id' => $booking_id,
        'user_id' => $user_id
    ];
}
