<?php

namespace Modules\Hotels\Tests\Unit;

use Tests\TestCase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\Request;
use Modules\Hotels\Http\Controllers\HotelsController;
use Faker\Factory as Faker;

class HotelsControllerTest extends TestCase
{
    public $session_key;
    public $hid;

    public function testAutoComplete()
    {
        $q = 'cairo';

        // Set up headers
        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
        ];

        // Generate the URL for the route
        $uri = action('Modules\Hotels\Http\Controllers\HotelsController@auto_complete', ['q' => $q]);
        $response = $this->withHeaders($headers)->get($uri);
        $responseData = json_decode($response->content(), true);
        $this->assertTrue($responseData['status']);
    }

    private function testSearch()
    {
        $faker = Faker::create();
        $checkinDate = $faker->dateTimeBetween('now', '+10 days')->format('Y-m-d');
        $checkoutDate = $faker->dateTimeBetween($checkinDate, $checkinDate . ' +3 days')->format('Y-m-d');
        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'eg',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
        ];

        // Generate the URL for the route with query parameters
        $uri = action('Modules\Hotels\Http\Controllers\HotelsController@search', [
            'checkin' => $checkinDate,
            'checkout' => $checkoutDate,
            'rooms[0][adults]' => 1,
            'rooms[0][children]' => 0,
            'id' => 31624,
            'type' => 'city',
            'nationality' => 'eg'
        ]);

        // Call the route directly with custom headers
        $response = $this->withHeaders($headers)->get($uri);
        $responseData = json_decode($response->content(), true);
        $this->session_key = $responseData['data']['Sessions']['tbo'];
        $this->hid = $responseData['data']['Hotels'][0]['TboCode'] . '-' . $responseData['data']['Hotels'][0]['ResultIndex'];
        $this->assertTrue($responseData['status']);
    }

    private function testAvailableRooms()
    {
        // $this->testSearch();
        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
        ];
        // Generate the URL for the route with query parameters
        $requestParams = [
            'hid' => $this->hid,
            'session_id' => $this->session_key
        ];
        $uri = action('Modules\Hotels\Http\Controllers\HotelsController@available_rooms', $requestParams);
        // Call the route directly with custom headers
        $response = $this->withHeaders($headers)->get($uri);
        $responseData = json_decode($response->content(), true);
        // dd($responseData);
        $this->assertTrue($responseData['status']);
    }

    private function testPricing()
    {
        // $this->testSearch();
        // $this->testAvailableRooms();
        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
        ];
        // Generate the URL for the route with query parameters
        $requestParams = [
            'hid' => $this->hid,
            'session_id' => $this->session_key,
            'room_block[0]' => 1,
        ];
        $uri = action('Modules\Hotels\Http\Controllers\HotelsController@pricing', $requestParams);
        // Call the route directly with custom headers
        $response = $this->withHeaders($headers)->get($uri);
        $responseData = json_decode($response->content(), true);
        $this->assertTrue($responseData['status']);
    }

    public function testBook()
    {
        $this->testSearch();
        $this->testAvailableRooms();
        $this->testPricing();
        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
        ];
        // Generate the URL for the route with query parameters
        $faker = Faker::create();

        // Generate random fields for lead guest and adults
        $leadGuest = [
            'title' => 'mr',
            'first_name' => $faker->firstName,
            'last_name' => $faker->lastName,
            'email' => $faker->email,
            'email_confirmation' => $faker->email,
            'mobile' => $faker->numerify('010########'),
            'nationality' => 'eg',
        ];

        $adults = [
            'title' => 'mr',
            'first_name' => $faker->firstName,
            'last_name' => $faker->lastName,
            'email' => $faker->email,
        ];

        // Generate random fields for the entire request
        $requestData = [
            'hid' => $this->hid,
            'session_id' => $this->session_key,
            'room_block[0]' => 1,
            'lead_guest' => $leadGuest,
            'booking_for' => 'me',
            'rooms' => [
                [
                    'adults' => [$adults],
                    'children' => [],
                ],
            ],
            'supplements' => '',
            'supplements_options' => [],
            'additions' => [],
            'AvailableForConfirmBook' => true,
        ];

        $uri = action('Modules\Hotels\Http\Controllers\HotelsController@booking');
        $bookHotelResponse = $this->post($uri, $requestData, $headers);
        $responseData = json_decode($bookHotelResponse->content(), true);
        $this->assertTrue($responseData['status']);
    }
}
